
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Mar 29 11:40:39 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_DataTstVectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */ 
/*lint --e{785} */ 
/************* Include Files ***********************************/
#include "SST_TST.h"
#if TST_USE_SPECIAL_DATA_MODULE
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/
TST_ATP_SpecialDataOpAESTestDataStruct TST_ATP_SpecialDataOpAESTestData[]=
{
   {
        /*TST_Name*/
        {"ATP test SpecialDataOpAES - AES/128bitKey/ECB/16ByteData"},
        /*TST_AesKey*/
        {0x3c,0xe0,0xfe,0x74,0xcf,0xf4,0x98,0x68,0xf1,0xd6,0x59,0x24,0xf8,0x52,0x75,0x66},
        /*TST_ChallengeBuff*/
        {0x9c,0x4b,0x03,0xbe,0x56,0xe5,0x28,0xbc,0x55,0x42,0x43,0x18,0x80,0x40,0x0b,0xb7,
         0xfc,0xfe,0x74,0xd0,0xf3,0x92,0x8e,0x43,0x95,0xfe,0x74,0xd0,0xf3,0x92,0x8e,0x8e},
        /*TST_ChallengeBuffSize*/
        32,
        /*TST_EncChallengeBuff*/
        {0x00},
        /*TST_AuthenticatorAESKey*/
        {0x3c,0xe0,0xfe,0x74,0xcf,0xf4,0x98,0x68,0xf1,0xd6,0x59,0x24,0xf8,0x52,0x75,0x66},
        /*TST_AESKeyType1*/
        SST_KEY_TYPE_AES_128_BIT,
        /*TST_AesKey2*/
        {0x00},
        /*TST_AESKeyType2*/
        SST_KEY_TYPE_AES_128_BIT,
        /*TST_AesKeyTemp*/
        {0x00},
        /*TST_AESKeyTypeTemp*/
        SST_KEY_TYPE_AES_128_BIT,
        /*TST_KeySizeInBytes*/
        16,
        /*TST_IVCounter*/       
        {0xb7,0x81,0x42,0x0c,0x38,0x06,0xd6,0x2a,0x96,0x09,0xbe,0xe4,0x54,0x4a,0xc7,0xa1},
        /*TST_OperationMode*/       
        CRYS_AES_ECB_mode,
        /*TST_DataIn*/       
        {0xe2,0xb7,0xd6,0x90,0x4d,0xc3,0x0a,0x2d,0x11,0xf0,0x62,0xce,0x71,0x3e,0x6a,0x20},
        /*TST_DataInSize*/ 
        16,
        /*TST_DataOut*/
        {0x84,0xb3,0xb3,0xc0,0xe3,0x5c,0x8f,0xaf,0x8d,0x80,0x79,0x91,0xf2,0x79,0x9b,0x47},
        /*TST_DataOutDecrypt*/
        {0x00},
    },
    #if !TST_LIMITED_MEMORY_PLATFROM
    {
        /*TST_Name*/
        {"ATP test SpecialDataOpAES - AES/128bitKey/ECB/512ByteData"},
        /*TST_AesKey*/
        {0xf4,0x9a,0x0a,0xff,0x03,0x45,0xc2,0xee,0x32,0x00,0xf7,0x5d,0xf6,0xbd,0xe4,0x00},
        /*TST_ChallengeBuff*/
        {0x9c,0x4b,0x03,0xbe,0x56,0xe5,0x28,0xbc,0x55,0x42,0x43,0x18,0x80,0x40,0x0b,0xb7,
         0xfc,0xfe,0x74,0xd0,0xf3,0x92,0x8e,0x43,0x95,0xfe,0x74,0xd0,0xf3,0x92,0x8e,0x8e},
        /*TST_ChallengeBuffSize*/
        32,
        /*TST_EncChallengeBuff*/
        {0x00},
        /*TST_AuthenticatorAESKey*/
        {0xf4,0x9a,0x0a,0x00,0x03,0x45,0xc2,0xee,0x32,0x00,0xf7,0x5d,0xf6,0xbd,0xe4,0x00},
        /*TST_AESKeyType1*/
        SST_KEY_TYPE_AES_128_BIT,
        /*TST_AesKey2*/
        {0x00},
        /*TST_AESKeyType2*/
        SST_KEY_TYPE_AES_128_BIT,
        /*TST_AesKeyTemp*/
        {0x00},
        /*TST_AESKeyTypeTemp*/
        SST_KEY_TYPE_AES_128_BIT,
        /*TST_KeySizeInBytes*/
        16,
        /*TST_IVCounter*/       
        {0xb7,0x81,0x42,0x0c,0x38,0x06,0xd6,0x2a,0x96,0x09,0xbe,0xe4,0x54,0x4a,0xc7,0xa1},
        /*TST_OperationMode*/       
        CRYS_AES_ECB_mode,
        /*TST_DataIn*/       
        {0xe4,0x4f,0x3b,0xe3,0xd4,0xb3,0xad,0xee,0xd5,0x90,0xbb,0x12,0xb5,0x48,0xce,0x6d,
        0x2f,0x79,0x98,0x2f,0xbf,0x82,0x93,0x44,0xb5,0x43,0xaa,0x34,0x89,0x24,0x35,0x47,
        0x6e,0x58,0x2b,0xec,0x29,0x63,0x93,0x5b,0x24,0xd9,0x3c,0x7a,0xbe,0x69,0xae,0xfd,
        0xe6,0x1b,0x60,0xd2,0xe8,0xd6,0x2c,0xbc,0x86,0x25,0xff,0x3e,0x4b,0x3a,0xd5,0xba,
        0x1c,0x34,0xe5,0xda,0x10,0x9d,0x18,0x2f,0x82,0x37,0xc0,0x18,0x64,0xf8,0x87,0xe6,
        0xd5,0x53,0xa5,0x3d,0xf6,0xb9,0x57,0xbd,0xfa,0x60,0x8c,0xe2,0x7d,0x43,0xe1,0x29,
        0x17,0x6a,0xcf,0x75,0x30,0x6b,0x23,0xb0,0x16,0x31,0xaf,0xb5,0x4c,0xfc,0x40,0x6e,
        0x26,0xa9,0xd0,0x39,0x92,0x34,0xfc,0x91,0x39,0x7b,0xb8,0xea,0xc7,0x44,0x41,0xdc,
        0x86,0x82,0x53,0x84,0x32,0xd4,0x9d,0x28,0x09,0x4f,0x72,0x19,0x21,0x7d,0xc1,0xde,
        0xfe,0xa5,0x47,0x8e,0x64,0x4d,0x03,0x7e,0x6a,0xfe,0xea,0x1c,0xd0,0x47,0xdd,0x1b,
        0x92,0x04,0xd8,0xd1,0xbd,0xe1,0x6c,0xdd,0x82,0x19,0x6f,0x0c,0x89,0x84,0xf2,0x7e,
        0x88,0xd0,0x73,0x04,0x13,0x0e,0x54,0xcd,0xb6,0x71,0x8c,0x42,0x41,0x53,0x9d,0x2e,
        0x63,0x79,0xc6,0x22,0x7a,0x98,0x79,0x18,0xaa,0x18,0x0f,0x56,0x2c,0x17,0xbb,0x95,
        0xe9,0xb1,0xbc,0x63,0x48,0x7f,0xd7,0xc6,0x44,0x5d,0x05,0x22,0xc1,0x71,0x69,0x5c,
        0x20,0x69,0x84,0x40,0x11,0x03,0xac,0x20,0xa8,0xd3,0xba,0xbe,0xb4,0x41,0x04,0x6d,
        0x4c,0xd1,0x8b,0x72,0xaa,0xa7,0x75,0xb0,0x3d,0x4a,0xbd,0x85,0xf9,0xa8,0x29,0xef,
        0xf2,0x5a,0x7c,0xf3,0x29,0x2a,0xed,0x3f,0xa5,0xd2,0xd9,0x0e,0xc6,0x07,0xb5,0x4c,
        0xd7,0xb6,0x46,0xfa,0xe2,0x8e,0x14,0xd5,0xc8,0xbe,0x1c,0x32,0x90,0x00,0xc5,0x2d,
        0x00,0xd6,0x15,0x02,0x6a,0x13,0x25,0xbb,0xc9,0x9e,0xd2,0x0c,0x0d,0x73,0xb6,0x7b,
        0xb2,0xea,0x57,0xc3,0x97,0x3c,0x9d,0x7b,0x0e,0x43,0x8a,0xf3,0x2f,0x81,0x25,0x5f,
        0x73,0x64,0xb7,0x37,0x7e,0xc8,0x3a,0xdd,0x3b,0xbe,0x0f,0x81,0x2e,0x8c,0xef,0x42,
        0x06,0xf5,0x24,0x95,0x72,0xba,0xf9,0xeb,0x36,0x60,0x6f,0x8e,0x7e,0x34,0x31,0xcc,
        0x72,0x8d,0xca,0x58,0x0a,0x51,0x16,0xed,0x24,0xba,0xf6,0x34,0xd4,0x5a,0x48,0xe8,
        0xfb,0x5d,0x17,0x38,0x1b,0x0f,0x0e,0x6d,0x69,0x9e,0x33,0xcc,0x24,0x20,0xd2,0xbe,
        0x26,0xd7,0xb6,0x2e,0xb9,0xb4,0x9f,0x33,0xab,0x1b,0xf1,0xef,0xa5,0xe6,0xaa,0xb7,
        0xb8,0xac,0x96,0x73,0x39,0x43,0xc6,0x48,0xcf,0x83,0x3e,0x75,0xca,0x4d,0xee,0x7b,
        0xb6,0xcc,0xe4,0x81,0x30,0xfb,0xbf,0xf6,0xf9,0x68,0x67,0x78,0x49,0x37,0xfb,0xf5,
        0x66,0x69,0x0b,0x10,0x74,0x5f,0x08,0xc6,0x8f,0x99,0xf8,0x51,0x17,0xc4,0x6e,0x4c,
        0x4b,0xf4,0xba,0x19,0x1a,0x2e,0x5d,0x80,0x35,0x29,0xc0,0x98,0x69,0x55,0x25,0xeb,
        0x2c,0x1d,0xdd,0xd5,0x76,0x69,0xbb,0x2d,0xd2,0x68,0xca,0x27,0xb4,0x8c,0x3b,0x79,
        0x0d,0xd6,0xa1,0xbd,0x1d,0x53,0x61,0x17,0x88,0xe7,0x63,0x17,0xad,0x49,0x0e,0xe1,
        0x33,0x4f,0x74,0x8b,0xe4,0x6c,0xc9,0xc6,0xbf,0x77,0x1a,0xc1,0x48,0xad,0x3b,0x4a},
        /*TST_DataInSize*/ 
        512,
        /*TST_DataOut*/
        {0x2b,0x51,0xc2,0xb5,0xfc,0x3c,0x92,0x98,0x00,0xe3,0x8e,0xb4,0xfc,0x5e,0xe7,0xde,
        0xe6,0x15,0x0b,0x8a,0x9e,0xf2,0x2e,0x7e,0x7a,0x32,0x9e,0x7a,0xcb,0x11,0x9a,0x90,
        0x63,0x16,0xaf,0x42,0xc3,0xcb,0x74,0x59,0x9a,0xec,0xfc,0x16,0x11,0x82,0xd1,0xff,
        0x74,0xb2,0xe6,0xde,0x92,0x74,0x4e,0x4e,0xb2,0x3e,0x91,0xca,0xdc,0x28,0x96,0x32,
        0x29,0xff,0x3c,0xdc,0xdf,0x42,0x2b,0xa6,0x5c,0xb3,0x8e,0x9b,0x25,0x74,0x6c,0x8d,
        0x85,0x60,0x12,0x56,0x35,0x4c,0x29,0x38,0xbc,0xb3,0x98,0xc6,0xe4,0x7d,0x62,0xa3,
        0xdc,0xa9,0x79,0xe2,0xba,0x25,0xda,0x0a,0xe2,0xad,0x21,0xd9,0x60,0x84,0x0d,0x4c,
        0x84,0x98,0x05,0xd4,0xff,0x86,0x57,0xd1,0x9a,0x6d,0x60,0xd9,0xc3,0xea,0x6f,0xe0,
        0x6c,0x93,0xb8,0xc7,0xaa,0xec,0x7c,0x44,0x27,0x71,0xee,0xef,0x3f,0xa4,0x9a,0xc2,
        0x03,0x3b,0x8f,0x80,0xc2,0x20,0x46,0x36,0x7e,0x5c,0x8a,0x06,0xdb,0xf4,0x40,0x63,
        0xdb,0x45,0x3c,0xa3,0x41,0xc3,0x8d,0xc8,0x54,0x24,0xac,0xdc,0x80,0x53,0x1b,0x3d,
        0x0a,0x86,0x78,0x03,0x3c,0xba,0x5e,0xaf,0x19,0x81,0x9a,0xcd,0x2f,0xfc,0x3f,0x27,
        0x52,0x15,0x87,0xb0,0x1b,0xc3,0x3f,0xda,0x58,0x8b,0x39,0x5b,0xce,0x42,0x6c,0x84,
        0xe4,0x97,0x84,0x1f,0x22,0x3b,0x1c,0x02,0x7d,0x60,0xb5,0xa0,0x66,0xe8,0xa2,0xc5,
        0x06,0x0a,0xa2,0x92,0x5a,0x73,0xd8,0x2b,0xa8,0x16,0xf7,0xfe,0xf6,0x45,0x75,0x0e,
        0x01,0xba,0xd2,0x57,0x43,0x98,0x82,0x84,0x7b,0x93,0x65,0xbd,0xdc,0x9a,0x52,0x53,
        0xfb,0xd5,0x42,0x38,0x48,0xab,0xf8,0x3d,0x3b,0xa6,0x89,0x57,0x89,0x76,0xd1,0x2d,
        0xe1,0x39,0x88,0x24,0x0d,0x6c,0x95,0x8f,0xb5,0x87,0xbb,0x34,0x3d,0x47,0x60,0x9f,
        0x40,0xf8,0x59,0x42,0xc4,0x29,0x5a,0x75,0xec,0xee,0x2b,0xa5,0x7a,0xf1,0x08,0x5a,
        0x95,0x7e,0xa7,0xa3,0x4d,0xf9,0xf5,0x13,0x9d,0x93,0xd6,0x64,0x60,0xa1,0xab,0xa7,
        0xb2,0x33,0x59,0x72,0x23,0xe7,0xf4,0xb5,0xaf,0xe7,0x96,0x02,0x7d,0x0e,0xdd,0xb9,
        0xce,0x3a,0x56,0x49,0xb3,0x8f,0x85,0x59,0x10,0x28,0x72,0x96,0xc9,0x08,0x7b,0xcc,
        0x7f,0xaa,0x17,0x2e,0x3f,0x35,0x56,0x43,0x35,0x38,0x8e,0x65,0xce,0x67,0xd4,0xe7,
        0x34,0xe7,0x69,0x72,0xa8,0xc2,0xf8,0x0c,0x80,0xe4,0xc7,0x81,0x96,0x62,0x37,0xb1,
        0x1e,0x5a,0x2d,0x95,0xf5,0xc2,0x09,0x3c,0x99,0xfe,0x23,0x1e,0x36,0x92,0x30,0x4f,
        0x85,0xd6,0xa3,0xa1,0x66,0x89,0x26,0x4a,0x19,0x90,0xd4,0x0e,0xb8,0xa0,0x6e,0x57,
        0x35,0xab,0x69,0x3c,0x90,0x5d,0xb2,0xa3,0xac,0x35,0xa6,0x7c,0x89,0xbe,0xdd,0xe2,
        0x6f,0xc7,0x80,0xc6,0x64,0x19,0x88,0x59,0xc6,0x4f,0x20,0xa9,0x80,0xc2,0x0b,0x5f,
        0xd8,0x2f,0x15,0x03,0x3f,0xda,0x40,0x73,0x26,0x8d,0xbb,0x7a,0xac,0xad,0x2c,0x92,
        0x2d,0x9c,0xe2,0xeb,0x7e,0x9a,0xcc,0x37,0x77,0x6f,0xcd,0x85,0x77,0xa7,0x1a,0x8b,
        0x64,0xdd,0xce,0xfc,0xe0,0xc3,0xbb,0x9a,0xc8,0x14,0x7a,0x13,0xb5,0x27,0xef,0xbf,
        0xb7,0xf7,0x19,0x7b,0xfb,0xc8,0xce,0x88,0xcd,0x0f,0x81,0x82,0xd4,0xfb,0x32,0x65},
        /*TST_DataOutDecrypt*/
        {0x00},
    },
#if (TST_SST_USE_AES_192_KEY==1)
    {
        /*TST_Name*/
        {"ATP test SpecialDataOpAES - AES/192bitKey/CBC/128ByteData"},
        /*TST_AesKey*/
        {0xf4,0x9a,0x0a,0xff,0x03,0x45,0xc2,0xee,0x32,0x00,0xf7,0x5d,0xf6,0xff,0xe4,0x00},
        /*TST_ChallengeBuff*/
        {0x9c,0x4b,0x03,0xbe,0x56,0xe5,0x28,0xbc,0x55,0x42,0x43,0x18,0x80,0x40,0x0b,0xb7,
        0x9c,0x4b,0x03,0xbe,0x56,0xe5,0x28,0xbc,0x55,0x42,0x43,0x18,0x80,0x40,0x0b,0xb7},
        /*TST_ChallengeBuffSize*/
        32,
        /*TST_EncChallengeBuff*/
        {0x00},
        /*TST_AuthenticatorAESKey*/
        {0xf4,0x9a,0x0a,0x00,0x03,0x45,0xc2,0xee,0x32,0x00,0xf7,0x5d,0xf6,0xbd,0xe4,0x00},
        /*TST_AESKeyType1*/
        SST_KEY_TYPE_AES_192_BIT,
        /*TST_AesKey2*/
        {0x00},
        /*TST_AESKeyType2*/
        SST_KEY_TYPE_AES_192_BIT,
        /*TST_AesKeyTemp*/
        {0x00},
        /*TST_AESKeyTypeTemp*/
        SST_KEY_TYPE_AES_192_BIT,
        /*TST_KeySizeInBytes*/
        24,
        /*TST_IVCounter*/       
        {0xb8,0xe4,0xed,0x96,0xfa,0xa3,0x5f,0x76,0xff,0xeb,0xc1,0xdd,0x62,0x39,0xb0,0xc5},
        /*TST_OperationMode*/       
        CRYS_AES_ECB_mode,
        /*TST_DataIn*/       
        {0x9f,0xe3,0x7e,0x2c,0x93,0x3b,0x19,0xab,0x65,0x15,0xda,0xbe,0x6d,0x7b,0x6f,0xe7,
        0x73,0x24,0x84,0xb8,0x14,0x48,0x42,0x43,0x67,0xb2,0x15,0xd1,0xe1,0x17,0xb3,0xd7,
        0x76,0xa6,0x5a,0x25,0x01,0xe0,0x58,0x61,0xe6,0xaa,0xd1,0xb4,0xf6,0xa1,0xbd,0xc3,
        0x93,0xad,0x30,0xe1,0x14,0xd9,0xde,0x82,0x6b,0x62,0xde,0xf3,0x04,0x0d,0xae,0x49,
        0xf1,0xbe,0x78,0x98,0x45,0x47,0x93,0x65,0xbd,0x7e,0x4d,0x5d,0xa6,0x92,0xe8,0x47,
        0xfa,0x9f,0xe2,0x37,0xcd,0x7f,0x7a,0x04,0xe7,0xe4,0x6f,0xfd,0xb3,0xa3,0x0b,0xd8,
        0x58,0x53,0x60,0xeb,0x25,0x17,0xd2,0x9f,0x32,0xb8,0xd5,0x21,0x44,0xf7,0xf8,0x5a,
        0xf2,0x21,0x23,0x22,0x06,0xe3,0x1c,0xb0,0x26,0x60,0x50,0x55,0xb4,0x81,0xd1,0x6b},
        /*TST_DataInSize*/ 
        128,
        /*TST_DataOut*/
        {0x37,0xbc,0xfe,0xd7,0x07,0x3b,0xb3,0x87,0x38,0x5c,0xc3,0x8c,0xfb,0x78,0x1c,0xe7,
        0x4c,0xcc,0x4c,0x61,0x00,0xb8,0x57,0xdd,0xc2,0x9d,0xa6,0x95,0x68,0x33,0x16,0x63,
        0x58,0x6a,0xe0,0xff,0x8b,0xc9,0xe5,0x0e,0xb7,0xbe,0x7a,0x98,0x88,0x16,0x35,0x49,
        0xf2,0xde,0x00,0xff,0x2c,0x16,0x11,0xdc,0x71,0x0b,0xf9,0x87,0x58,0xe3,0xf0,0x38,
        0xaf,0x9b,0xd7,0x5b,0x14,0x54,0x07,0xee,0x0e,0x39,0x19,0x3a,0x9d,0xef,0xc6,0x53,
        0x6f,0x89,0x43,0xcb,0x43,0xc1,0x29,0x1d,0xa7,0xed,0xb8,0x9e,0xcd,0x3e,0x6d,0xa4,
        0x15,0x3c,0xb6,0xfc,0x6a,0x77,0x7d,0x46,0x50,0xba,0x15,0xf4,0x1e,0xb1,0xe6,0x89,
        0x2c,0xb7,0x71,0xc0,0x20,0x88,0x9e,0xcf,0xc1,0x1b,0xc1,0xae,0xb4,0x9c,0x87,0x37},
        /*TST_DataOutDecrypt*/
        {0x00},
    },
#endif
    #endif
#if (TST_SST_USE_AES_256_KEY==1)
    {
        /*TST_Name*/
        {"ATP test SpecialDataOpAES - AES/256bitKey/CTR/32ByteData"},
        /*TST_AesKey*/
        {0xf4,0x9a,0x0a,0xff,0xff,0x45,0xc2,0xee,0x32,0x00,0xf7,0x5d,0xf6,0xff,0xe4,0x00},
        /*TST_ChallengeBuff*/
        {0x16,0x80,0xc1,0xaf,0x47,0x07,0x1e,0x00,0x53,0x22,0x51,0x1f,0x10,0xdf,0x7c,0xb3,
        0x56,0x45,0xdf,0x0c,0x06,0x43,0xfb,0xb7,0x4b,0xe7,0xf7,0x4f,0x20,0xd1,0x42,0x95},
        /*TST_ChallengeBuffSize*/
        32,
        /*TST_EncChallengeBuff*/
        {0x00},
        /*TST_AuthenticatorAESKey*/
        {0xf4,0x9a,0x0a,0x00,0x03,0x45,0xc2,0xee,0x32,0x00,0xf7,0x5d,0xf6,0xbd,0xe4,0x00},
        /*TST_AESKeyType1*/
        SST_KEY_TYPE_AES_256_BIT,
        /*TST_AesKey2*/
        {0x00},
        /*TST_AESKeyType2*/
        SST_KEY_TYPE_AES_256_BIT,
        /*TST_AesKeyTemp*/
        {0x00},
        /*TST_AESKeyTypeTemp*/
        SST_KEY_TYPE_AES_256_BIT,
        /*TST_KeySizeInBytes*/
        32,
        /*TST_IVCounter*/       
        {0x00,0xe4,0xed,0x96,0xfa,0xa3,0x5f,0x76,0xff,0xeb,0xc1,0xdd,0x62,0x39,0xb0,0xc5},
        /*TST_OperationMode*/       
        CRYS_AES_CTR_mode,
        /*TST_DataIn*/       
        {0x62,0x7a,0x29,0xaa,0x2f,0x74,0x59,0x01,0xb5,0x84,0x83,0xb3,0x4d,0xf0,0xe6,0xd3,
        0x51,0xf7,0xd6,0x35,0xd3,0xb5,0x0f,0x76,0x8f,0x46,0x49,0x3c,0x1f,0x2e,0x0c,0xbf},
        /*TST_DataInSize*/ 
        32,
        /*TST_DataOut*/
        {0x01,0xdb,0xef,0xc7,0x73,0xe4,0x5c,0x7d,0xb0,0xc6,0x2e,0xb7,0x33,0x5b,0x14,0x35,
        0x3b,0x2b,0xf1,0x1d,0xf0,0x69,0x0d,0xd2,0x0f,0x58,0xef,0x04,0xfd,0x66,0x73,0xe4},
        /*TST_DataOutDecrypt*/
        {0x00},
    },
#endif
};

/*DES*/
TST_ATP_SpecialDataOpDESTestDataStruct TST_ATP_SpecialDataOpDESTestData[]=
{
    #if !TST_LIMITED_MEMORY_PLATFROM
    {
        /*TST_Name*/
        {"ATP test SpecialDataOpDES-DES/1Key/ECB/1536"},
        /*TST_Password*/
        {0x07,0x2e,0xc7,0xc5,0x9d,0x0d,0x83,0xbb,0x78,0x85,0x3e,0x67,0x1c,0xde,0xa8},
        /*TST_PasswordSizeInBytes*/
        14,
        /*TST_MaxNumOfTrials*/
        2,
        /*TST_DesKey1*/
        {0x56,0x7e,0x8b,0x09,0x0d,0x39,0xff,0xfc},
        /*TST_DESKeyType1*/
        SST_KEY_TYPE_1DES,
        /*TST_DESKey2*/
        {0x00},
        /*TST_DESKeyType2*/
        SST_KEY_TYPE_1DES,
        /*TST_DESKeyTemp*/
        {0x00},
        /*TST_DESKeyTypeTemp*/
        SST_KEY_TYPE_1DES,
        /*TST_KeySizeInBytes*/
        8,
        /*TST_IVCounter*/       
        {0x86,0x9e,0x5e,0x31,0xf3,0xac,0x70,0x8b},
        /*TST_OperationMode*/       
        CRYS_DES_ECB_mode,
        /*TST_DataIn*/       
        {0x4d,0xcf,0x98,0xff,0x77,0x38,0xea,0xa5,0xf5,0xb2,0xe0,0xd1,0x80,0x21,0xa4,0x9c,
        0x20,0x7e,0x13,0xf8,0x4d,0x72,0x08,0xe6,0x54,0x23,0xde,0xea,0xfd,0x4e,0x30,0xbc,
        0x6b,0x96,0xe3,0x41,0x43,0x1b,0x67,0xb9,0x11,0x4f,0x39,0x3a,0xe7,0x05,0xad,0x5d,
        0x47,0xcb,0xea,0x37,0x42,0x7a,0x36,0x8b,0xe2,0x0b,0x74,0x3d,0xc6,0xac,0xea,0x0a,
        0x0c,0x13,0x48,0x77,0x74,0x13,0xe6,0x07,0xc1,0x6d,0x4e,0xb1,0x63,0xe8,0xfa,0x91,
        0x54,0xa4,0x5f,0xde,0x40,0xab,0x2a,0x1c,0xe8,0xc9,0xc9,0x93,0xc8,0x9e,0x2d,0xff,
        0xf7,0xf1,0xce,0x89,0x50,0x47,0xf0,0xf6,0xcf,0xb4,0x25,0x1f,0x3d,0xf2,0x14,0xa1,
        0x10,0xb0,0x78,0xd5,0x8d,0x2c,0x6c,0x03,0x2f,0x04,0xe5,0xd2,0x4c,0x4a,0x80,0x03,
        0xf6,0xd6,0x7e,0x5f,0x20,0xe0,0x0c,0xee,0x01,0xce,0xc8,0x6a,0xbe,0x4a,0x82,0xf3,
        0x43,0x98,0x3f,0x04,0x71,0x26,0x84,0xa6,0x7f,0x65,0xd1,0xe4,0x9a,0xd8,0x6b,0x7e,
        0xcf,0x6b,0x5e,0xe2,0x2b,0x05,0xc3,0x57,0x21,0x60,0x3f,0x7c,0x2b,0x19,0xcc,0xf1,
        0xb4,0x03,0xbc,0x54,0x36,0xc1,0xfb,0x6f,0xa0,0x94,0x94,0xaf,0xfa,0x71,0x76,0xd8,
        0x4b,0x57,0x79,0xf8,0xbb,0xdf,0x9c,0x9a,0xf5,0x15,0x90,0x3b,0xcf,0x86,0x7b,0x02,
        0x2d,0x9a,0xf6,0xab,0x22,0x24,0x57,0xc5,0x59,0x38,0x36,0x1d,0xb4,0x3d,0x2a,0x7a,
        0x32,0x42,0xd4,0x8a,0x16,0x96,0x1f,0x1d,0x46,0x92,0xc5,0x91,0xf1,0xba,0x16,0x8d,
        0x74,0x05,0xf5,0xf3,0x7f,0x78,0x23,0x0f,0x73,0xf9,0xc0,0x15,0x0f,0x63,0x0e,0xca,
        0x4c,0xd6,0x79,0x81,0x85,0x51,0xd4,0x49,0xdb,0x82,0xe6,0x65,0xd8,0xdc,0x25,0xfc,
        0x53,0xeb,0xc1,0x12,0x93,0xe4,0xe4,0xb7,0xb7,0x81,0x39,0x7e,0x54,0x0b,0xab,0x31,
        0x61,0xb8,0x6f,0xc3,0x50,0x38,0x44,0x86,0x7e,0x8b,0xf9,0x9e,0xcd,0x15,0x30,0xb6,
        0x8f,0xf4,0x63,0xf2,0xa7,0x91,0x24,0x24,0xea,0x75,0xa9,0x42,0xcc,0x5f,0x87,0x18,
        0x38,0x93,0xbe,0x3a,0xbf,0x74,0xf6,0x3d,0xf5,0x55,0x08,0x26,0x18,0x8d,0xc0,0x23,
        0xf3,0xc9,0xe2,0x79,0x02,0xa7,0x6a,0xbe,0xd7,0x80,0x18,0x48,0xbc,0x84,0x2c,0xe5,
        0x9a,0x0d,0x6f,0xcc,0x1a,0x2d,0x72,0xd4,0x09,0x89,0x1a,0xe4,0x01,0x6b,0x5c,0xab,
        0x46,0x12,0x46,0x91,0xee,0x4d,0x3f,0xed,0x45,0x48,0x8f,0x78,0x6f,0xa5,0x22,0x02,
        0x4f,0xce,0x88,0x63,0xa8,0x8a,0x41,0xb5,0x82,0xcf,0x38,0xc0,0xd0,0xd8,0x8d,0xb6,
        0x4f,0x76,0x97,0x21,0xb1,0xab,0x2a,0x19,0xfb,0x75,0x15,0xba,0x2c,0xe8,0xef,0xd5,
        0x1f,0x7f,0x14,0xe6,0xb2,0xb4,0xea,0x46,0x28,0xce,0x69,0xa2,0xcc,0xfb,0xda,0xac,
        0xd7,0x9e,0xde,0x10,0x94,0xea,0xb3,0xaa,0xc2,0xb0,0xb3,0xf6,0x3a,0x75,0x1d,0xc8,
        0xd2,0xc8,0x18,0x3d,0x80,0xd3,0xf5,0xf1,0xc3,0x2f,0xb5,0x72,0x3e,0xfd,0xcb,0xf5,
        0xa6,0x32,0x23,0x48,0xdf,0x32,0x62,0x08,0x62,0xa1,0x70,0x14,0xe2,0x75,0x34,0x41,
        0x2f,0x50,0x9e,0x50,0x5a,0x0e,0xeb,0x1d,0x1a,0x99,0x24,0x18,0x6e,0x05,0xe8,0xf9,
        0x84,0xd9,0x6c,0xb0,0xda,0xaa,0xc0,0x9b,0xa3,0xef,0x54,0xfc,0x6c,0x10,0xba,0xaa,
        0xff,0xc0,0xad,0x07,0x88,0x8d,0x53,0x31,0xf6,0xb5,0xbf,0x7d,0xa4,0x3c,0xba,0x21,
        0x39,0x3b,0xc3,0x30,0xcd,0x7b,0x54,0xcc,0x4d,0x42,0x67,0x97,0x20,0x6d,0x39,0x6a,
        0x0a,0xbf,0x4e,0x4a,0x51,0x79,0xb5,0x97,0x1f,0x2b,0x8d,0x87,0x28,0xc9,0xc8,0xd3,
        0x8c,0x01,0x2f,0xb0,0xff,0xcc,0xa6,0x01,0x27,0x44,0xb2,0xcb,0x45,0xb5,0x38,0xe9,
        0x18,0xf6,0x88,0x01,0xff,0xfa,0x99,0xb6,0x5d,0xa2,0x96,0x1f,0x41,0xd5,0x9a,0x78,
        0x47,0xd3,0xb9,0x18,0xb9,0xc6,0x3f,0xa3,0xfa,0x9b,0x3c,0x81,0x25,0x0f,0x40,0x8f,
        0xf1,0x0d,0x63,0x14,0xd8,0x37,0x88,0xf6,0x78,0xc3,0xe3,0x2e,0x39,0x88,0xb9,0x79,
        0x30,0x58,0x67,0x50,0x43,0x91,0xa6,0x1b,0x8e,0xef,0x0d,0xa2,0x06,0xa4,0xd8,0xc4,
        0x5c,0xab,0xe7,0x6b,0x25,0x59,0x0a,0xbf,0x37,0x35,0x7b,0x9a,0x56,0x09,0xac,0x3c,
        0x10,0x39,0x43,0x41,0xe5,0x54,0x63,0xd0,0xab,0xe9,0x2e,0x14,0x31,0x9c,0x88,0xf0,
        0x23,0x78,0x1d,0xee,0x2d,0x87,0xa5,0x79,0x63,0xa0,0x67,0x4d,0xe1,0x81,0xfb,0x2b,
        0xae,0x1e,0x55,0xd1,0xe7,0x38,0xff,0x29,0x19,0x30,0xa6,0xc1,0xee,0x1e,0xd8,0x7b,
        0x0c,0x1e,0x0c,0x86,0x3a,0xea,0xe3,0x8c,0xc4,0xae,0xad,0x2d,0x21,0x17,0x2f,0xad,
        0xd4,0xad,0xa4,0xe9,0x90,0x64,0x01,0x90,0x9f,0x6d,0x7d,0x8f,0x85,0x52,0x51,0xcd,
        0xe0,0x42,0xbc,0x19,0x92,0xaa,0x4b,0x61,0x22,0x05,0x57,0x24,0x60,0xf4,0xcf,0x29,
        0x48,0x91,0x38,0x72,0x29,0x00,0xf1,0x6c,0x07,0x48,0xbc,0x68,0x3d,0x61,0x7a,0x4e,
        0x66,0x8f,0x36,0x90,0x7e,0xee,0x65,0x5e,0x45,0x4d,0x6c,0x19,0xe4,0x3f,0x63,0x09,
        0xd3,0x70,0x19,0x52,0xfa,0x36,0x58,0x24,0x17,0x68,0x6a,0x33,0x5f,0x73,0xdb,0x67,
        0x68,0xaa,0x81,0xd4,0x46,0xde,0xba,0xec,0xf5,0x2f,0xf5,0xf3,0xf7,0x21,0x74,0xb4,
        0x3d,0xf3,0x50,0x73,0x4b,0x2c,0xbd,0x22,0x98,0x76,0x8f,0xd8,0x33,0xaf,0xfd,0x7e,
        0xac,0x3e,0xa5,0xcc,0x32,0xa3,0xd1,0x74,0xf9,0x52,0xf9,0x9c,0xdf,0xc2,0x89,0x92,
        0x4e,0xc1,0xe3,0xbb,0x64,0x0a,0xa8,0xcd,0x51,0x19,0x34,0x3e,0x01,0x3e,0x67,0xfd,
        0xfc,0xf1,0xab,0x5f,0x8a,0x65,0x32,0x5c,0x1a,0x60,0x80,0xfb,0xe4,0x49,0x2a,0x0b,
        0xce,0x83,0xdd,0x14,0x8c,0xf9,0xa1,0x8d,0x0c,0xfa,0x5f,0x4f,0x11,0x48,0xa1,0x4a,
        0x1e,0x6b,0x9a,0x77,0x95,0x4b,0x66,0x0d,0x20,0xfe,0x93,0xf8,0x50,0xdf,0xdf,0x87,
        0x84,0xe0,0x43,0x65,0x0d,0x21,0x31,0xca,0x8f,0xc1,0x1b,0xf2,0xaa,0xf4,0x34,0xcf,
        0xda,0x55,0x7a,0xfb,0x9c,0x7e,0xf4,0xf0,0xd3,0xd6,0x38,0x7b,0x69,0xab,0x31,0x6e,
        0x39,0x81,0x1f,0x96,0x2d,0xa9,0xdf,0xec,0xa3,0x15,0x6d,0x0f,0x16,0x6a,0xa7,0xf2,
        0xfa,0x57,0x54,0xd2,0xe7,0x26,0x64,0x6c,0xfa,0x90,0x79,0x6c,0x79,0xd6,0xa7,0x28,
        0xb5,0x0d,0x78,0x8e,0x35,0xb9,0x34,0x5b,0x10,0x9e,0x5f,0x8f,0x9b,0xd3,0x82,0x1d,
        0x44,0x18,0x2f,0xe6,0xbe,0x69,0x3f,0xe8,0x5f,0xd4,0x5e,0xb3,0xc6,0x87,0xca,0x1d,
        0xc0,0x2d,0x57,0x37,0x6d,0x7b,0xb7,0x80,0x9e,0x05,0xf8,0x58,0x82,0x57,0x4e,0xb7,
        0x82,0x41,0x13,0x1e,0x69,0x72,0x0c,0xce,0xc8,0x48,0xee,0x39,0x99,0xe7,0x20,0xb6,
        0x22,0x89,0xc3,0x78,0x1c,0x15,0xf0,0xc1,0x15,0xf2,0x40,0x53,0x13,0x1d,0x92,0x28,
        0x7a,0x79,0x08,0x62,0x2f,0x67,0x53,0x85,0xfe,0x97,0x31,0xe4,0x39,0x1e,0x33,0x59,
        0xa2,0xc8,0xc4,0x39,0x8b,0xaf,0x67,0x87,0x3c,0x0c,0x40,0x68,0x95,0x4e,0xd6,0xd7,
        0xf5,0x69,0x17,0x9a,0x5a,0x71,0x9d,0x75,0xc9,0x67,0x2f,0x9d,0xf0,0x53,0x8b,0x6f,
        0x0a,0x92,0x62,0x62,0x03,0x72,0xa5,0x3b,0xdc,0xfc,0xff,0x80,0x52,0x11,0xa3,0x2e,
        0xba,0xb9,0x47,0xae,0x30,0xb7,0x70,0x06,0xf0,0x61,0xf1,0x4d,0x04,0xae,0xae,0x61,
        0x20,0x91,0xa6,0xdc,0xca,0x85,0x31,0x43,0xbd,0x69,0x85,0x81,0x90,0x8f,0x7f,0x94,
        0x93,0x10,0xa1,0x87,0xfa,0x62,0x57,0xa0,0x3d,0x2c,0x7e,0xda,0xbe,0x58,0x26,0x95,
        0xad,0x6a,0x97,0x8d,0x28,0x11,0x93,0x09,0xa7,0xfc,0xdb,0x55,0x98,0xef,0xf5,0x71,
        0x46,0x16,0x2b,0x0b,0xff,0x99,0xd7,0xab,0x76,0x70,0xde,0x2e,0x66,0x79,0x7b,0x75,
        0x78,0xc8,0x3e,0x5e,0x67,0x3e,0x54,0xf3,0x62,0x5d,0x08,0xe2,0xb2,0x5a,0x8a,0x2e,
        0x9c,0x74,0xef,0x23,0x89,0x85,0x7a,0x8f,0x64,0xd7,0x1a,0x2f,0x44,0x38,0x33,0x68,
        0x4b,0x51,0xa1,0x37,0xce,0x33,0xfb,0x6b,0xb5,0x33,0x14,0x12,0x25,0xf8,0xc8,0x31,
        0x5d,0xd2,0xf5,0xb8,0xde,0x4d,0xc7,0xb4,0xcf,0x07,0x39,0xc7,0x9f,0xbe,0xd8,0xd5,
        0xec,0xad,0xca,0x01,0xa4,0x19,0x10,0xd8,0x6a,0x27,0x08,0xcb,0x3b,0xf0,0x36,0xe3,
        0x51,0xd7,0x43,0xb0,0x47,0x1b,0x46,0x83,0x7f,0xa8,0x43,0xdd,0xc1,0x33,0xf1,0x26,
        0x24,0x85,0xc1,0xa2,0x32,0x17,0x1b,0xa2,0x47,0xe0,0xeb,0xf7,0x3a,0x6b,0x5c,0xac,
        0x3f,0x2c,0xe3,0xf5,0x0c,0x14,0x80,0x62,0x3b,0x63,0x41,0x58,0xf0,0xbe,0x07,0xc2,
        0xbb,0x81,0x8c,0x04,0xc0,0x56,0xa5,0x30,0x15,0x07,0xc5,0x7d,0x6b,0x90,0xc3,0xf5,
        0xf1,0x79,0xdd,0x6d,0x75,0x62,0xfc,0xba,0xcc,0xe0,0x3a,0x22,0x75,0x87,0xa1,0x11,
        0x79,0x48,0x35,0x0d,0x95,0xfe,0x35,0xec,0x9b,0x43,0x9f,0x45,0x16,0x88,0xf2,0x24,
        0x2d,0x65,0x37,0x02,0xca,0x2d,0x42,0xf4,0xfb,0xc6,0x36,0x22,0x98,0xb7,0x47,0x7b,
        0x26,0x83,0xc4,0xa7,0xfb,0x36,0x54,0x3d,0xa3,0x3d,0x80,0x37,0x83,0x7a,0x71,0xa3,
        0xbc,0x98,0xfb,0x9b,0x52,0x9c,0xdb,0x76,0x8e,0xbd,0x3d,0x40,0xa0,0x76,0x82,0x68,
        0x89,0xd9,0x3f,0xb9,0x38,0x26,0x89,0x8b,0xf3,0x9c,0x70,0x3b,0xf9,0x8f,0xc9,0xd8,
        0x66,0xbb,0x31,0x1f,0x56,0xd8,0x4e,0xaa,0x4d,0x6f,0x58,0x64,0xd7,0xeb,0xd8,0x40,
        0x6b,0xf3,0xb0,0x2b,0x95,0xf7,0x5c,0x3f,0x55,0x09,0x77,0x39,0xc2,0xef,0x81,0x2d,
        0xf2,0x76,0xdf,0x78,0x1e,0x09,0x23,0xf7,0x02,0x81,0x8e,0x76,0x83,0x3f,0xd3,0x6b,
        0x94,0x78,0x1e,0xe5,0x5a,0xd1,0x55,0xbf,0x8e,0x2c,0x9e,0x19,0x24,0xc1,0x21,0x08,
        0x2a,0x70,0x0f,0x8d,0xf2,0x55,0xe3,0xc4,0x73,0x9e,0xe8,0x5e,0xed,0x99,0xfb,0x51,
        0xcc,0x11,0x92,0xce,0xcf,0xdb,0xfd,0x74,0x69,0xac,0xec,0xc3,0x68,0x2e,0x32,0xd3},
        /*TST_DataInSize*/ 
        1536,
        /*TST_DataOut*/
        {0xa0,0x78,0x69,0x71,0x59,0x44,0x4b,0x9b,0x4f,0xb4,0xe3,0xfc,0xcf,0x65,0x0f,0xff,
        0xe7,0x80,0x4a,0xb8,0xfd,0xf2,0xa7,0x7d,0xae,0x43,0xa6,0x42,0x9c,0x6f,0xcc,0xc5,
        0x72,0xca,0x0e,0xfa,0xaf,0xc9,0xdc,0x6f,0xec,0x8d,0x98,0x16,0xd0,0x56,0xdb,0x1c,
        0x55,0x18,0x79,0x0c,0xa4,0x55,0x3e,0x91,0x0b,0xf6,0xbf,0xc5,0x71,0x6a,0x1a,0x9a,
        0x92,0x5b,0xdf,0xfd,0x21,0x0b,0x26,0x29,0x65,0x73,0x61,0xab,0x58,0x30,0xba,0xd9,
        0x8f,0xad,0xfd,0xbd,0x70,0xe5,0x4b,0xcb,0x76,0xa8,0xc6,0xc9,0x13,0x00,0x64,0xd7,
        0xc9,0x3f,0x67,0x96,0x34,0x6f,0xab,0x70,0xb8,0x33,0x8a,0xf6,0xad,0x42,0x65,0x1b,
        0xa8,0xc5,0xf2,0xb1,0x3b,0x60,0x70,0xb6,0xf1,0x33,0x8a,0x67,0x78,0xfc,0x8b,0x40,
        0xa1,0x8f,0x72,0x08,0x54,0x88,0x70,0x74,0x97,0x26,0x2f,0xec,0xcf,0x57,0x31,0xfe,
        0x2a,0x31,0x27,0x9d,0xdf,0xb2,0x0f,0x9f,0x52,0x06,0x2e,0xc6,0xff,0xb2,0x8c,0x16,
        0x32,0x95,0x3f,0x1e,0x92,0x9a,0x18,0xf9,0xde,0xbf,0x6a,0x5e,0x41,0x6d,0xd6,0x57,
        0x75,0xf7,0x38,0x62,0xb9,0x4a,0x83,0xbe,0x3d,0xb1,0x21,0x61,0x1b,0x15,0xd7,0xb6,
        0x40,0x5c,0x6e,0x17,0x70,0x16,0xdf,0x4f,0xb2,0x01,0xe5,0x17,0x04,0x81,0xe3,0x93,
        0x45,0x0b,0x0b,0x59,0xf7,0x42,0xe7,0xcf,0x32,0x0d,0xd9,0x6f,0xf7,0x62,0x35,0x7d,
        0xd0,0x54,0xde,0xf5,0xc6,0xe2,0x4e,0xe3,0x19,0x93,0x85,0x16,0x24,0x3a,0x28,0x86,
        0x1c,0x63,0x89,0x68,0x16,0x28,0x20,0x6b,0xd5,0x3a,0x48,0x0b,0xf2,0xed,0x12,0xd4,
        0xe1,0x59,0xee,0xe2,0x71,0x0e,0xb5,0x54,0x6a,0x1f,0x2b,0xaa,0x25,0x0e,0x08,0x99,
        0xcb,0xf1,0xe1,0x13,0x6e,0x7d,0xfd,0xf3,0xba,0x2b,0x52,0x2a,0x18,0xc1,0xa3,0xb4,
        0xf8,0x1c,0xc8,0x1a,0xa3,0x2a,0x64,0x96,0x9f,0x96,0x6c,0xa2,0x13,0x24,0xda,0x8b,
        0x98,0xcc,0x43,0x44,0x54,0x0e,0x63,0x9e,0x51,0x73,0xb8,0xeb,0x91,0xdf,0x26,0x71,
        0xb9,0x08,0xc4,0x0b,0xe7,0x78,0x03,0xae,0x7e,0x34,0xb5,0x36,0x87,0xe7,0xa3,0xb1,
        0x30,0xc0,0xc2,0x0b,0xbd,0x89,0xdb,0x3b,0x7e,0x9d,0xd0,0xf8,0x89,0x56,0x3a,0xc8,
        0x94,0xb3,0x57,0x49,0x0e,0x12,0x87,0x05,0x57,0x8d,0x1c,0xde,0x4a,0x8c,0x3c,0xf3,
        0x38,0xf1,0x15,0x84,0x0f,0xb2,0xdc,0x30,0x9a,0x85,0xc5,0x0d,0x36,0xaa,0x2c,0xf6,
        0x98,0x98,0xc8,0x5d,0xdf,0x7a,0x01,0xc7,0x05,0xff,0xc3,0xa2,0x5c,0xff,0x05,0x24,
        0xc4,0x7c,0xe1,0x2a,0x04,0x96,0x93,0xcf,0x61,0xdd,0xf8,0x3f,0xc3,0xd0,0x6c,0x3c,
        0x6d,0x05,0x1d,0xe3,0x78,0xbe,0x9e,0x3e,0x92,0xd0,0x88,0x01,0xe5,0x93,0x44,0x36,
        0x05,0xf1,0xf9,0xd8,0x79,0x7e,0x4d,0xb2,0x8d,0x4f,0xc4,0x94,0x50,0x8c,0xe0,0x62,
        0x79,0x7e,0xcd,0xfe,0x31,0x1f,0x5b,0xb2,0xa0,0xfc,0x4b,0xe8,0x17,0x1f,0x57,0x87,
        0x45,0x77,0x94,0x84,0xab,0x36,0x7b,0x25,0xfb,0xf3,0xa6,0x7c,0x3a,0x1d,0x68,0x72,
        0x5c,0x04,0xdb,0x7c,0xb9,0x9d,0xf2,0x30,0x21,0xc8,0x30,0x50,0x4f,0x53,0x9a,0xee,
        0x67,0x50,0xb5,0x19,0x42,0xd4,0x32,0x37,0xd2,0x2f,0x79,0xe3,0xe0,0x48,0x5a,0x1d,
        0xc5,0xbd,0xc4,0x3d,0xfd,0x50,0x34,0x58,0x15,0x9c,0x89,0x15,0x34,0x2e,0x82,0xef,
        0xea,0x56,0x98,0x59,0xaa,0x75,0x80,0xcb,0x6d,0x3a,0x59,0x89,0x40,0x2e,0xcc,0xa4,
        0x42,0xaf,0x62,0xab,0x74,0x0b,0xd0,0x09,0xc0,0x8e,0xdf,0x1a,0x9a,0xa1,0xae,0x0e,
        0x39,0x0e,0x01,0x9c,0x10,0xce,0x14,0x97,0xd3,0xc8,0xaa,0x46,0x23,0x96,0xe0,0xe9,
        0x92,0xe1,0x14,0x09,0x73,0x25,0x19,0xbd,0xc0,0xd9,0x05,0x82,0x6a,0x18,0x5e,0x16,
        0x9a,0xb0,0x6e,0x02,0x4c,0xbc,0xaa,0xca,0x19,0xef,0xe0,0x2d,0xb5,0x3d,0x4b,0xca,
        0x62,0xb9,0x2d,0x71,0x5f,0xac,0x68,0x7f,0xd6,0x2f,0x78,0x25,0x1d,0x98,0x71,0xb8,
        0xff,0xb2,0xb4,0x95,0xcd,0xdf,0xa2,0x8b,0x14,0x55,0xbc,0xb2,0x50,0x4c,0x83,0x5e,
        0x19,0xba,0xd1,0xcd,0x17,0x9e,0xc1,0x65,0x9e,0x56,0xf4,0x84,0xf8,0xa6,0x7a,0xf2,
        0x3d,0x83,0x8f,0x3b,0x08,0x34,0xc6,0x98,0x41,0x9f,0x18,0x4f,0x21,0x5e,0x57,0x92,
        0x57,0x14,0xba,0xe4,0x0a,0xdf,0xf4,0x1b,0xec,0x94,0x29,0x25,0x67,0x6e,0xa2,0xe1,
        0xe0,0xbb,0x50,0xc7,0x6c,0xa4,0xcd,0xff,0xbf,0xcf,0x06,0xc1,0x1f,0x5e,0xf0,0x08,
        0xf5,0x23,0x1a,0xba,0x76,0xc2,0x59,0x62,0x78,0x80,0x80,0xb9,0x02,0x4f,0x02,0xb4,
        0xbe,0x6b,0xfa,0x89,0x7e,0xd6,0x21,0xe5,0x64,0x6c,0xaa,0x61,0x00,0xb3,0x0f,0x99,
        0x71,0xaf,0x25,0xba,0xd3,0x1a,0xbe,0xf4,0x08,0x80,0xf5,0x27,0x76,0x1e,0x59,0x78,
        0x7b,0xa6,0xd6,0x4f,0x4a,0x49,0x9a,0xdd,0xc5,0x00,0x0c,0xa2,0x4d,0xa6,0x1a,0x89,
        0x62,0x50,0xb8,0x81,0x6d,0xc1,0xbb,0x2b,0x92,0x08,0x8c,0x71,0x5d,0xd5,0x76,0x28,
        0xc4,0xbd,0xb9,0xde,0xc6,0xaa,0x59,0x69,0x51,0x68,0xa5,0x89,0xb6,0xec,0xd4,0x1d,
        0x94,0xad,0x82,0x00,0x9c,0xe3,0x16,0xe6,0x67,0x9e,0xc6,0xd7,0x74,0xca,0xee,0x19,
        0xf1,0xea,0xa2,0xd1,0x4f,0x25,0xe2,0x75,0xaa,0x57,0x51,0x1f,0x02,0x58,0x8b,0x80,
        0x46,0xd9,0xc4,0x5e,0x00,0xe4,0x5c,0xab,0xcf,0x04,0x04,0x0c,0x5f,0xf6,0xb7,0x05,
        0xf8,0x83,0x99,0xb8,0xe1,0x49,0x08,0xaa,0x6b,0x9f,0x7e,0xe6,0x3b,0xfc,0x00,0x6c,
        0x97,0xb8,0x84,0xf3,0x7c,0xa9,0x8e,0x53,0xbf,0x2f,0x84,0x78,0x24,0xc1,0x87,0x3d,
        0xb1,0x4f,0x6e,0x2b,0x49,0x12,0x63,0x9b,0xbf,0x06,0xbc,0x70,0x87,0xad,0xea,0xc1,
        0x72,0xe1,0x3a,0x6d,0xe1,0x76,0xe5,0x4d,0xd1,0x1f,0x06,0xb0,0x8c,0xeb,0xde,0x5c,
        0x24,0x27,0x79,0xf2,0x56,0x5a,0xd1,0xd9,0xba,0xab,0x0e,0x5f,0x56,0x2c,0xf1,0xd7,
        0xb1,0x09,0x01,0x71,0x67,0x1b,0x24,0x1a,0x32,0xa6,0x40,0x72,0xa8,0x1d,0x71,0xd6,
        0x3d,0xa3,0x7d,0x39,0xeb,0xfa,0xa8,0xd2,0xda,0x98,0x74,0x30,0xc3,0x1b,0xd6,0x9f,
        0x80,0x61,0xd9,0xda,0x0c,0x9d,0x7a,0x81,0x88,0xac,0x0a,0x81,0xce,0x87,0x75,0x91,
        0xc7,0x9d,0x5c,0xac,0x39,0xf6,0xbe,0xd3,0x60,0x1b,0x79,0x30,0xbe,0x20,0x01,0x84,
        0xcd,0xb5,0x28,0xe9,0x5f,0x6d,0xb9,0x9b,0xd5,0x21,0xe7,0xa1,0xd7,0x73,0xe7,0x56,
        0xd9,0xdd,0x63,0x92,0x6a,0xd2,0xb8,0xfe,0x30,0x94,0x5c,0x25,0x40,0x3b,0x6f,0x42,
        0x9a,0x9c,0xe9,0xaf,0xe7,0x0c,0xd7,0xbd,0xe5,0xcd,0x23,0x6f,0xa2,0xbe,0xd4,0xb1,
        0xf4,0xfb,0x95,0x65,0x57,0xcb,0x2f,0xc1,0x76,0x32,0x10,0x42,0x4c,0xdb,0x0e,0x42,
        0x16,0x00,0xb1,0xd2,0xc1,0xb7,0x18,0x31,0x0a,0x13,0x48,0xc1,0x5e,0x9c,0xfb,0x33,
        0x7a,0x9a,0xa7,0xaf,0xc8,0xa7,0x75,0xa2,0x02,0xa2,0x7e,0x55,0x9a,0x82,0x93,0xff,
        0xfa,0x4a,0x7b,0xa1,0xc2,0xd1,0xb2,0x2b,0x44,0xc3,0x79,0xd1,0x87,0xa2,0x27,0x34,
        0x79,0x7f,0x16,0x09,0xba,0xd0,0x98,0xb3,0xab,0xf8,0x7b,0xff,0x21,0x25,0xa7,0x33,
        0x3a,0x93,0x73,0x20,0x90,0x1a,0xbb,0x0a,0x23,0x16,0x9b,0x81,0xac,0xff,0xf1,0x31,
        0xcf,0xf4,0x30,0xfe,0x51,0x0b,0x6c,0x07,0x7f,0xa6,0x8b,0xe5,0xb7,0xc6,0x3d,0x73,
        0x07,0xf6,0xeb,0x72,0xb7,0x18,0xb5,0x9d,0x98,0x06,0xff,0x38,0x52,0x3b,0xd4,0x35,
        0xc3,0x61,0xbd,0x95,0x42,0xa7,0x40,0x4c,0x02,0xaa,0x4a,0x86,0x4c,0xc0,0xb0,0x9d,
        0x93,0xc0,0x96,0x22,0x59,0x77,0x1d,0x51,0x35,0x6b,0x3c,0x49,0x43,0x28,0xeb,0x53,
        0xa1,0x3e,0x28,0x1f,0x20,0x60,0xbf,0x12,0xfa,0x4b,0xbd,0x24,0xf4,0x7d,0x28,0xc8,
        0x41,0x28,0x10,0x8e,0x1d,0xe3,0xa0,0xd5,0x25,0x01,0x39,0x06,0x33,0x91,0x51,0x13,
        0xf4,0xd5,0x66,0x01,0x84,0x49,0xfd,0x82,0xe0,0x4d,0xa7,0x12,0x9e,0x22,0xe6,0x4b,
        0x1d,0xd5,0x13,0xac,0x46,0x90,0xa7,0x7d,0xc8,0xd2,0x6a,0xaa,0x7f,0x7c,0x50,0xa0,
        0x65,0x8a,0xa2,0x4a,0x23,0x37,0x57,0x76,0x38,0x57,0x77,0x56,0xbd,0xe2,0x1d,0x66,
        0x61,0xef,0x0a,0xc1,0xd2,0xe6,0x15,0xb4,0x6e,0x42,0x5b,0x76,0xc9,0x8f,0x93,0x33,
        0x2b,0xe4,0x3a,0xe4,0xef,0x2b,0xb1,0x57,0xfd,0x60,0xc5,0x39,0xc8,0xac,0xf6,0x60,
        0x3c,0x50,0x62,0x16,0xe1,0x18,0x02,0x0c,0x2a,0x1e,0xb6,0x6f,0xa4,0xe5,0xea,0xfb,
        0xe3,0x10,0xf9,0xfe,0xf2,0xd3,0x19,0x37,0xb7,0x5c,0xae,0xde,0x38,0x2a,0xdc,0x7d,
        0x96,0x9c,0x2b,0x1e,0x3d,0xed,0x93,0x95,0xc3,0x9f,0x88,0xc2,0x48,0xb1,0x88,0x1e,
        0xc0,0xd3,0x2f,0x7c,0xaf,0xe8,0xcb,0x77,0x0d,0x41,0xac,0xee,0x3f,0x0e,0x87,0xcc,
        0x88,0x22,0x0e,0x59,0xd4,0xbc,0xf3,0x26,0x0d,0x44,0x5a,0x44,0xa5,0x28,0xd1,0x9e,
        0xb4,0x30,0xf9,0x6a,0xc2,0x65,0xd0,0x42,0xf8,0x53,0x74,0x6d,0x69,0xbf,0x63,0x8b,
        0x91,0x6c,0x92,0x57,0xb8,0xc6,0x14,0x6f,0xf9,0x67,0x9f,0x4a,0x19,0x83,0x1f,0x7d,
        0x91,0x09,0x5f,0xc8,0x04,0x6c,0x13,0xb8,0x6e,0x08,0xe0,0x80,0xb3,0x59,0xe8,0xb3,
        0x22,0x1b,0x17,0xb6,0xa7,0xf0,0x86,0x17,0xf8,0x6a,0x5f,0x86,0x50,0xd8,0xf9,0x7f,
        0xc0,0xdb,0x9d,0xad,0x89,0x96,0xff,0xef,0x34,0x8c,0x25,0x62,0xbe,0x2c,0xf6,0xdd,
        0x74,0x11,0x2d,0x57,0x4f,0x2a,0xb0,0x32,0x64,0x33,0x52,0xda,0x8d,0x5a,0x8e,0xf5,
        0xe4,0x09,0x10,0x8d,0xec,0x25,0x5f,0x0f,0x20,0x98,0x91,0x22,0x5f,0x90,0xc5,0xce,
        0x53,0xe5,0x9e,0x93,0xe8,0x31,0x6d,0xc8,0xaf,0x85,0xc9,0x5d,0x16,0x29,0x9b,0x50,
        0x80,0x05,0xea,0x8a,0x03,0xb6,0xaa,0x68,0xce,0x3f,0x38,0x93,0xc9,0x86,0x2d,0xbd},
        /*TST_DataOutDecrypt*/
        {0x00},
    },
    #endif
    {
         /*TST_Name*/
         {"ATP test SpecialDataOpDES-DES/3Key/CBC/128"},
         /*TST_Password*/
         {0xe4,0x65,0xc2,0xbb,0x8e,0x0d,0x16,0x1c,0x9b,0x9a,0x95,0x6e,0x75,0xde,0x98,0x3a},
         /*TST_PasswordSizeInBytes*/
         16,
         /*TST_MaxNumOfTrials*/
         7,
         /*TST_DesKey1*/
         {0xd2,0x70,0x45,0xe9,0x07,0x39,0xef,0x1c,0x1a,0x3f,0x64,0x6b,0x62,0x0b,0x57,0xce,
         0xc5,0x79,0x83,0x23,0x7d,0x6d,0x91,0x7e},
         /*TST_DESKeyType1*/
         SST_KEY_TYPE_3DES,
         /*TST_DESKey2*/
         {0x00},
         /*TST_DESKeyType2*/
         SST_KEY_TYPE_3DES,
         /*TST_DESKeyTemp*/
         {0x00},
         /*TST_DESKeyTypeTemp*/
         SST_KEY_TYPE_3DES,
         /*TST_KeySizeInBytes*/
         24,
         /*TST_IVCounter*/       
         {0xd5,0x5b,0xab,0x43,0x52,0x4f,0xc7,0x45},
         /*TST_OperationMode*/       
         CRYS_DES_CBC_mode,
         /*TST_DataIn*/       
         {0xc4,0x0b,0x2e,0xd1,0xf2,0xe0,0xd3,0xb3,0x19,0x43,0x65,0x0e,0x14,0x71,0xba,0xb2,
         0x80,0x68,0x69,0x2a,0xcb,0xa9,0x7e,0x9f,0x8d,0x3d,0x72,0xfa,0x1c,0xf6,0x5a,0x49,
         0x5b,0xf7,0x5e,0x64,0xd2,0x76,0x6d,0xd0,0x04,0xc1,0x2f,0xe3,0xfc,0x7f,0x3b,0x29,
         0x2a,0x39,0x8b,0x07,0x6d,0x19,0x2c,0x9e,0x71,0xf1,0x3a,0xf2,0x3b,0x7e,0x0c,0x4c,
         0x02,0xef,0xac,0xdd,0x41,0xa1,0x8a,0xa3,0x0a,0x2d,0x71,0x91,0x9d,0xa4,0xb9,0xea,
         0x39,0x19,0xbf,0xee,0x32,0x60,0x92,0xb8,0x44,0x16,0xef,0x67,0x27,0xe1,0x70,0x7c,
         0x63,0xf9,0x00,0x83,0x66,0xe8,0x92,0xf6,0xd4,0x8e,0x13,0x5e,0x1e,0x67,0x9c,0xbb,
         0x56,0x11,0xed,0x26,0x42,0x08,0x17,0xb5,0xaf,0xb5,0x78,0x9f,0x07,0xa7,0xec,0xa0},
         /*TST_DataInSize*/ 
         128,
         /*TST_DataOut*/
         {0xff,0xa1,0x90,0xbf,0x8f,0x02,0x55,0xbc,0x18,0x87,0x5b,0xd9,0xfd,0x28,0x25,0x9a,
         0x5f,0xeb,0x3b,0x42,0x88,0xa2,0x38,0xc6,0xb5,0xcd,0x71,0xcc,0x1d,0x8c,0x69,0x95,
         0x93,0xa5,0x91,0xa8,0x6b,0x14,0x3b,0x10,0x8a,0x48,0x69,0xae,0x6e,0xf4,0xd9,0x72,
         0x84,0xc5,0x40,0x6e,0x16,0x85,0x86,0xb6,0xb8,0x2f,0xb1,0x42,0x9b,0x85,0xe6,0xca,
         0xd7,0x6b,0x05,0x43,0xee,0x6d,0xbf,0x47,0x3c,0x8d,0x75,0xa9,0x80,0x40,0xc1,0x20,
         0x2b,0x5d,0xa1,0xfe,0x5a,0x60,0x25,0x35,0x3b,0x0e,0xee,0xdb,0x72,0xd1,0xbc,0x79,
         0x36,0xad,0x80,0x17,0x5f,0xec,0x57,0xe1,0x23,0x14,0x5c,0x57,0x2b,0x16,0x1d,0x36,
         0x1e,0x57,0xa7,0x14,0xe9,0x90,0x82,0x8f,0xee,0x7d,0xf3,0x5d,0x6d,0xdb,0x73,0x1f},
         /*TST_DataOutDecrypt*/
         {0x00},
    },
  #if !TST_LIMITED_MEMORY_PLATFROM
    {
        /*TST_Name*/
        {"ATP test SpecialDataOpDES-DES/2Key/CBC/512"},
        /*TST_Password*/
        {0xe4,0x65,0xc2,0xbb,0x8e,0x0d,0x16,0x1c,0x9b,0x9a,0x95,0x6e,0x75,0xde,0x98,0x3a},
        /*TST_PasswordSizeInBytes*/
        16,
        /*TST_MaxNumOfTrials*/
        7,
        /*TST_DesKey1*/
        {0x28,0x39,0xEA,0x4B,0x34,0x32,0xFD,0x7E,0x71,0x0C,0x77,0x29,0xA0,0xC6,0x98,0x94},
        /*TST_DESKeyType1*/
        SST_KEY_TYPE_2DES,
        /*TST_DESKey2*/
        {0x00},
        /*TST_DESKeyType2*/
        SST_KEY_TYPE_2DES,
        /*TST_DESKeyTemp*/
        {0x00},
        /*TST_DESKeyTypeTemp*/
        SST_KEY_TYPE_2DES,
        /*TST_KeySizeInBytes*/
        16,
        /*TST_IVCounter*/       
        {0xd5,0x5b,0xab,0x43,0x52,0x4f,0xc7,0x45},
        /*TST_OperationMode*/       
        CRYS_DES_CBC_mode,
        /*TST_DataIn*/       
        {0xFF,0xF5,0x2A,0xE4,0x48,0xD2,0x82,0x78,0x52,0x7A,0x4D,0x52,0x49,0xD3,0x86,0x80,
         0x35,0xE2,0x0B,0xC0,0x9A,0xF3,0x2B,0x7B,0xA7,0xDF,0xBF,0x66,0xA2,0x12,0x42,0xA2,
         0xDD,0x0F,0xF5,0xFB,0xDB,0x2F,0x74,0xAE,0xED,0xD8,0xD8,0x30,0xC5,0xCF,0x7D,0x60,
         0x56,0x34,0xA4,0xA4,0xFE,0x9F,0x55,0x0B,0xCA,0xAF,0x3C,0x69,0x13,0x1B,0xD6,0x3F,
         0x37,0xAA,0x75,0x3A,0xDE,0x8A,0xA5,0x06,0x6E,0x5C,0xD2,0xC2,0x1A,0xFB,0xB6,0xD8,
         0x61,0x5F,0x10,0x6D,0x6D,0x9E,0xA3,0x3D,0xB9,0xE9,0x31,0x2B,0xF2,0x0A,0x9B,0xD2,
         0x02,0x99,0xF8,0x1A,0x5A,0x42,0x81,0xCC,0x8F,0x9E,0x35,0xA1,0xCD,0x93,0xF0,0xCF,
         0xF9,0x64,0x07,0xB4,0x0B,0x68,0xD1,0x99,0x06,0x37,0x81,0xF5,0x58,0x79,0x13,0x63,
         0xC1,0x00,0xC0,0x81,0x03,0x9B,0x7E,0x1F,0xDD,0x43,0xDE,0xCE,0x68,0x02,0x70,0x25,
         0xF8,0x61,0x32,0x8D,0x03,0xE7,0xC6,0x99,0xC7,0x5E,0x13,0x22,0xC1,0x8C,0x73,0x15,
         0x8B,0xD2,0xDF,0xCC,0xD3,0x6F,0xCC,0x5D,0xE6,0xE8,0xD6,0xC8,0x89,0x02,0x31,0x04,
         0xC7,0x5B,0xFC,0xF7,0x47,0x86,0x5F,0xDA,0x39,0x26,0xB9,0xA4,0x88,0x5B,0x5E,0x50,
         0xCF,0xC9,0x43,0x95,0x22,0xA3,0x52,0x88,0x95,0xD5,0xA6,0x1B,0x10,0xFE,0x10,0xC5,
         0x2C,0x0E,0x5A,0x65,0x90,0x7C,0xCE,0x04,0x73,0x05,0x93,0xAD,0xB5,0x27,0xD4,0x8A,
         0x89,0x86,0xF8,0xC0,0xBE,0x9C,0xE2,0x24,0x09,0x73,0x61,0x71,0xDF,0x44,0xCA,0x3B,
         0x15,0xF4,0x78,0x79,0x01,0xF9,0xC0,0x53,0xFA,0x3E,0x22,0x1D,0x10,0xA4,0xD3,0x6D,
         0x00,0x1B,0x91,0x8A,0x06,0x4F,0x06,0x8F,0x2C,0x36,0x5B,0x1C,0x1A,0x5C,0x25,0x2E,
         0x3B,0x57,0x97,0xC1,0xAE,0x5B,0x89,0x90,0xC5,0xA4,0xC5,0x7F,0x7A,0xC4,0x14,0x64,
         0xA0,0xF3,0x71,0xC3,0xB2,0x3F,0x35,0xC5,0xEE,0xE8,0x4C,0xCB,0x9D,0xA3,0x38,0x9E,
         0x19,0xF3,0xE2,0xB8,0x0D,0x11,0xBF,0xA4,0x92,0x01,0xC4,0x61,0x8A,0x86,0x15,0x67,
         0x22,0xF6,0x7C,0x26,0xEA,0x61,0x7C,0xFB,0x22,0xD1,0xD2,0xC6,0x0E,0xBE,0xF2,0x21,
         0x6C,0x27,0x66,0x86,0xE2,0x5B,0x57,0x8E,0x34,0xCC,0x31,0xB1,0x7A,0xD3,0x3B,0x68,
         0xD3,0xE5,0xA8,0xA6,0x27,0x11,0xB3,0xB7,0x77,0xE7,0x96,0x3C,0x3F,0xF9,0x96,0xD3,
         0x0E,0xA3,0xF5,0x63,0x1F,0x8E,0x85,0xC6,0x9F,0xED,0xF2,0x1D,0x30,0xCA,0x80,0x4E,
         0x95,0x6A,0xF2,0x29,0x15,0x4C,0xFA,0x5A,0x73,0xAE,0x0F,0xFB,0xC4,0x1B,0x4F,0x3B,
         0x36,0x5D,0xA2,0xD7,0xDE,0xD8,0x48,0x44,0x5F,0xE2,0x06,0x39,0x1F,0x95,0x87,0xAC,
         0x66,0x48,0xA6,0xD4,0x06,0x6D,0xBE,0xC2,0xA8,0x9A,0xEF,0x71,0x7F,0x89,0x01,0x84,
         0x9E,0xB6,0xE7,0xD2,0x28,0xA8,0x6F,0xBD,0x21,0xAE,0xC9,0x33,0x45,0xC0,0x3A,0xDE,
         0x26,0x62,0x94,0x7C,0x75,0x7A,0x35,0xC9,0x9F,0xE0,0x2F,0x43,0xE8,0xD7,0xC4,0xD5,
         0xE0,0x82,0x9A,0x69,0xAE,0xB5,0x84,0xBE,0xD8,0xE8,0xB2,0x57,0xA3,0x8A,0x7C,0xE7,
         0x60,0x11,0x4A,0x1D,0xF4,0x85,0x0F,0x24,0x80,0x1E,0x32,0x48,0x79,0x2B,0xD5,0x4A,
         0xE9,0xF3,0x52,0xC2,0x26,0xD1,0x30,0x71,0xDE,0xD6,0xA3,0x8D,0xC7,0xDD,0x25,0x14},
         /*TST_DataInSize*/ 
         512,
         /*TST_DataOut*/
        {0x56,0xA9,0x0B,0x3A,0xC1,0x99,0xC3,0x44,0x8E,0xC1,0xAE,0x51,0x56,0xEF,0x51,0xA1,
         0xCF,0x05,0xDC,0x2A,0xCD,0xC8,0x88,0x28,0xFE,0xBF,0xDD,0x06,0xA4,0x8C,0xFF,0x79,
         0xAA,0xE3,0xC5,0xEE,0x2A,0x09,0x7C,0xB8,0x4E,0x77,0xB3,0x1D,0x66,0x22,0x67,0xBB,
         0xA2,0x19,0x9B,0x1C,0x65,0x31,0xE1,0x3A,0xD6,0xBD,0x08,0x0D,0x43,0x99,0x3C,0xDE,
         0xFD,0x91,0xEE,0x9C,0xD6,0xEF,0x58,0xD3,0x46,0x1C,0x67,0x42,0x06,0x2E,0x40,0xC4,
         0xFA,0xAF,0x27,0xDA,0xDC,0x74,0x60,0x58,0x90,0xC2,0xEB,0x02,0x6C,0x51,0x3F,0xEA,
         0xBB,0xBB,0xA1,0xE6,0x5F,0x77,0x79,0x33,0x46,0x80,0x7C,0xF0,0x75,0x2B,0x58,0x13,
         0x44,0x37,0x47,0x06,0x65,0xF3,0x84,0xEA,0x63,0x8A,0x3E,0x8D,0xFD,0xDF,0xA0,0xEC,
         0x77,0x56,0x13,0xF6,0x29,0x23,0xD0,0x29,0x24,0x93,0x93,0x01,0x86,0x88,0xAE,0x75,
         0x5D,0xA5,0x04,0x10,0x2A,0x2D,0xFB,0x79,0xC3,0xAA,0xA1,0xFF,0xFD,0x4F,0x89,0x40,
         0x7D,0xF5,0xB9,0x50,0x12,0x80,0x2D,0x11,0x6D,0x35,0x84,0x8D,0xE6,0x4F,0x9F,0xC7,
         0x40,0xA5,0xDE,0xEE,0xF9,0x72,0xB9,0x32,0x99,0x2C,0x02,0x2F,0x38,0x5D,0xC7,0x09,
         0x07,0xEE,0xA7,0x41,0x12,0xB0,0xF1,0xBC,0x43,0xC9,0x0E,0xBD,0xB4,0xC0,0xED,0x80,
         0x59,0x5A,0x3A,0x23,0xD7,0x66,0x54,0xFE,0x75,0x58,0xF9,0x43,0xEF,0x4C,0xB1,0xEB,
         0x54,0x47,0xCD,0xFA,0x32,0x21,0xB5,0xDE,0x5F,0x26,0x60,0x4D,0x1C,0xFE,0xA8,0x76,
         0x68,0xE2,0x33,0x0F,0xA2,0x83,0xEA,0xA2,0xB3,0xEA,0xBB,0xA6,0x47,0x46,0xB6,0x20,
         0x45,0xE6,0xC1,0x00,0xD4,0xEC,0xDB,0x65,0xF6,0x11,0x88,0x93,0x58,0x58,0x0D,0x50,
         0x92,0x89,0xAD,0xCE,0x7C,0xC6,0x0B,0x41,0x31,0x7D,0x8F,0x60,0xA7,0x9F,0x1D,0x92,
         0x6A,0xFD,0xB0,0xE0,0xEC,0x85,0x49,0xA8,0x58,0x52,0xA1,0x75,0xBC,0xAB,0x20,0x49,
         0x25,0x30,0x31,0xA6,0xF9,0xEC,0x31,0x54,0xD7,0x30,0x91,0xB1,0xDC,0xD8,0x96,0x10,
         0x39,0x07,0xB2,0xDC,0x2A,0xA6,0x60,0xF9,0xC8,0x4F,0xEB,0xEF,0xF9,0x03,0x25,0x80,
         0x3B,0xFD,0x0E,0xEC,0xA6,0x71,0xD3,0x12,0xEB,0x3B,0xB7,0x72,0x05,0x81,0xDC,0x15,
         0xC4,0x55,0x0F,0x15,0x3D,0x8A,0x99,0xDC,0x29,0xB8,0x3A,0x0C,0xF7,0x10,0xF7,0x70,
         0xF5,0x9A,0x1B,0x00,0xE7,0xED,0xC9,0x34,0xD6,0x5C,0xD6,0x36,0x39,0x1B,0x78,0x72,
         0x44,0xFE,0x56,0xD7,0x2D,0x66,0x0B,0xE1,0x82,0xA0,0x45,0x57,0x47,0x02,0xB9,0x8E,
         0x73,0xA5,0x1D,0x40,0xD9,0x55,0x90,0x88,0xC5,0x71,0x60,0x58,0x23,0x49,0x79,0x10,
         0x6F,0x6F,0xBD,0x3B,0xA1,0x62,0xC9,0xDC,0xD4,0x43,0x6A,0xE6,0x96,0x60,0xC5,0xE0,
         0x30,0x6C,0xC7,0x31,0xC4,0x58,0xF2,0xEF,0x3D,0x5A,0x27,0xB5,0xAB,0xE8,0xC7,0x56,
         0xF8,0xDE,0x47,0xB4,0xA5,0x98,0xCE,0x5C,0x8A,0xF2,0x61,0xA3,0x9D,0x06,0x90,0x8A},
         /*TST_DataOutDecrypt*/
         {0x00},
    },
   #endif

};

TST_ATP_SpecialDataOpHMACTestDataStruct TST_ATP_SpecialDataOpHMACTestData[]=
{
    {
        /*TST_Name*/
        {"ATP test SpecialDataOpHMAC-SHA1/64ByteKey"},
        /*TST_Password*/
        {0xbe,0xe7,0xc3,0x1a,0x82,0x6e,0xef,0x8b,0x8b,0x80,0x73,0x18,0xde,0xdd,0x98,0x31,
        0x38,0x1f,0x23,0xd9,0xa2,0xfb,0x87,0x08,0x44,0xc4,0x59,0x4e,0x7e,0x30,0x04,0xba,
        0x35,0x5f,0xbe,0xfa,0x6b,0x19,0xbb,0xc3,0x13,0x58,0xa0,0x74,0x23,0x06,0x3a,0xf6,
        0xea,0x07,0x70,0xe6,0xa4,0x7a,0x76,0xf6,0x4c,0x3c,0x44,0x90,0xb1,0xae,0x47,0xbd,
        0xcc,0xb9,0x56,0x46,0x51,0x0f,0xe7,0x19,0x84,0xb3,0x83,0xed,0x4e,0xbb,0x77,0x29,
        0x90,0x55,0xcd,0x02,0xb7,0x08,0x7a,0xe4,0x91,0x3c,0xd9,0x14,0x5f,0xfd,0x58,0x93,
        0x2b,0xfc,0x72,0x45,0x5b,0xd6,0xdd,0x52,0x87,0x99,0x04,0xcd,0x88,0x85,0xb7,0x94,
        0xd1,0x0f,0x21,0x77,0x03,0x2c,0xfb,0x9c,0xbb,0xcb,0x00,0x21,0xae,0xa3,0xa1,0x04},
        /*TST_PasswordSizeInBytes*/
        128,
        /*TST_MaxNumOfTrials*/
        3,
        /*TST_HMACKey1*/
        {0xf0,0x94,0x01,0x61,0x39,0xfc,0x44,0x65,0x01,0x60,0x1c,0x12,0xa1,0xcd,0x32,0xf8,
        0xb7,0x74,0xc4,0xed,0x10,0xfd,0xa9,0x02,0xcc,0x1d,0x8f,0xb6,0xbc,0x6b,0x88,0x69,
        0x0f,0x6f,0xc5,0x13,0x2e,0xfc,0xa0,0x35,0xe4,0xc0,0xe0,0x10,0xc2,0x1a,0x39,0x16,
        0xc2,0x2b,0x13,0x9e,0x2a,0x30,0x8d,0xdb,0xb3,0x0f,0xc0,0x0f,0xeb,0x2f,0x48,0xfc},
        /*TST_HMACKey1Size*/
        64,
        /*TST_HMACKey2*/
        {0x00},
        /*TST_HMACKey2Size*/
        64,
        /*TST_HMACKeyTemp*/
        {0x00},
        /*TST_HMACKeyTempSize*/
        64,
        /*TST_OperationMode*/ 
        CRYS_HASH_SHA1_mode,
        /*TST_DataIn*/  
        {0x2d,0xbb,0x64,0x5b,0xce,0xdc,0x2d,0xb8,0xcc,0xe1,0x60,0x99,0xfc,0x1b,0x9c,0x72,
        0x13,0x37,0x61,0x0e,0xba,0x0b,0xc7,0x78,0xe5,0x90,0x70,0x1c,0x60,0x2a,0xbb,0x2a,
        0xaa,0x30,0x3a,0x3b,0x07,0xa8,0x67,0x37,0xd1,0x52,0x92,0x76,0x0f,0xe9,0x1e,0x25,
        0x49,0xa5,0xed,0xec,0x9a,0x04,0x19,0xcd,0x06,0xca,0xe5,0x50,0x0e,0x46,0xf3,0xdd,
        0x82,0xd8,0xb7,0x69,0x97,0xb0,0x2b,0x55,0x39,0xd8,0xc4,0x92,0xa2,0x75,0xa5,0x0a,
        0x2c,0x4a,0x14,0x3b,0x63,0x7d,0x2a,0x25,0x5f,0x9e,0xce,0x67,0x51,0xe5,0xe4,0xa5,
        0x5b,0xbb,0xc1,0x2c,0xa5,0x7c,0xe2,0xd9,0xad,0x7c,0xde,0x37,0xde,0x48,0x9a,0xe7,
        0x65,0x2e,0xbc,0x45,0x40,0xff,0x62,0x48,0x97,0x13,0x13,0xaa,0x50,0x8e,0xf6,0x49},
        /*TST_DataInSize*/
        128,
        /*TST_DataHMAC_Result1*/
        {0x00},
        /*TST_DataHMAC_Result2*/
        {0x00},
        /*TST_HASHSize*/
        CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES,
    },
    {
        /*TST_Name*/
        {"ATP test SpecialDataOpHMAC-SHA256/128Byte key"},
        /*TST_Password*/
        {0x31,0x82,0x23,0x32,0x21,0x2f,0xe3,0xdd,0xa3,0x64,0x56,0x92,0x94,0x97,0xe6,0xa6,
        0x4c,0xd4,0x40,0xa2,0x7e,0x10,0x57,0x39,0x5f,0xbb,0xac,0x7d},
        /*TST_PasswordSizeInBytes*/
        28,
        /*TST_MaxNumOfTrials*/
        3,
        /*TST_HMACKey1*/
        {0x85,0xb3,0x2d,0xe0,0xd1,0x8e,0x9b,0xd6,0x70,0x77,0xd2,0x9f,0x0c,0xfb,0x76,0x5f,
        0x0d,0x79,0xbf,0x79,0x17,0x8f,0x22,0xa5,0xd3,0xd2,0x2e,0x44,0xf3,0xc2,0xb4,0xf1,
        0x70,0xfd,0x2a,0x59,0x16,0xb2,0x51,0x4c,0x43,0x59,0x16,0x14,0xec,0xa1,0xb6,0x05,
        0xe0,0xaa,0x26,0x55,0x51,0x75,0xb2,0x2e,0x90,0x99,0xe4,0x02,0x18,0x37,0xa7,0x1f,
        0xce,0x2f,0xac,0x83,0x87,0x94,0x0d,0xf1,0xcb,0x5e,0x31,0x44,0xd9,0x5f,0xef,0x04,
        0xea,0x79,0xf6,0x37,0xba,0x0d,0x6c,0x79,0x45,0xb6,0xd5,0x4f,0xce,0x38,0x37,0xb9,
        0x26,0xb3,0x7b,0x06,0x2b,0x1d,0x17,0xec,0x8f,0xee,0xea,0xd8,0xdb,0x1d,0x67,0x83,
        0xb3,0x4c,0xf6,0xc6,0x5b,0x40,0x97,0xaf,0x7a,0x93,0xc9,0xd4,0x1e,0xad,0xaa,0xe7},
        /*TST_HMACKey1Size*/
        128,
        /*TST_HMACKey2*/
        {0x00},
        /*TST_HMACKey2Size*/
        128,
        /*TST_HMACKeyTemp*/
        {0x00},
        /*TST_HMACKeyTempSize*/
        128,
        /*TST_OperationMode*/ 
        CRYS_HASH_SHA256_mode,
        /*TST_DataIn*/  
        {0x1d,0x8d,0x23,0x23,0x8b,0x0e,0x85,0x8c,0xe3,0x8f,0xa4,0x87,0x29,0x58,0xba,0x38,
        0x82,0x49,0x33,0x26,0xe9,0xc0,0x07,0x3f,0x24,0xbd,0x46,0x1c,0xf6,0x44,0xf5,0x87,
        0x97,0x03,0x18,0x3a,0x61,0x35,0x10,0xea,0xcc,0xc6,0x27,0x84,0x9c,0xb8,0x6a,0xb7,
        0x59,0xc5,0xb7,0xb2,0x00,0x46,0x16,0x2f,0xf8,0x53,0x4c,0xb0,0x47,0x2c,0xae,0x08,
        0x06,0xd7,0x34,0x1e,0x12,0x0b,0xce,0xee,0x05,0x4d,0xfb,0xd0,0x65,0x59,0x97,0xfd,
        0x1b,0xc3,0xf4,0x4f,0x26,0xde,0x2d,0x48,0x90,0xdd,0xb7,0x56,0xa1,0x38,0x39,0x55,
        0x54,0x52,0x9e,0x56,0x07,0x58,0x68,0x9f,0x76,0x6c,0x47,0xf3,0xea,0x03,0xea,0x13,
        0xae,0x8b,0x15,0x84,0xc3,0x52,0xf4,0x93,0xd4,0xa3,0xaf,0x97,0x6c,0x32,0x3e,0x76},
        /*TST_DataInSize*/
        128,
        /*TST_DataHMAC_Result1*/
        {0x00},
        /*TST_DataHMAC_Result2*/
        {0x00},
        /*TST_HASHSize*/
        CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES,
    },
};


TST_ATP_SpecialDataOpRSATestDataStruct TST_ATP_SpecialDataOpRSATestData[]=
{
    {
        /*TST_Name*/
        {"ATP test AuthObject-SpecialDataOpRSA - 1024 key"},
        /*TST_ChalengeKeySizeInBytes*/
        256,
        /*TST_N*/
        {0xbd,0x0c,0x65,0x0a,0x5d,0x18,0x41,0x32,0x94,0xfc,0xde,0x65,0x0c,0x2d,0xa5,0x1e,
        0x3f,0xd8,0xaf,0x63,0x4f,0x2c,0xb2,0xa5,0x71,0xb9,0x75,0xa5,0x3e,0x5c,0x55,0x85,
        0x1c,0x2d,0xfa,0x75,0x5e,0xd3,0xd3,0x42,0x78,0x36,0x05,0xe6,0x31,0x48,0xfa,0xaa,
        0x3b,0x56,0x38,0xe3,0x51,0x01,0x39,0x49,0xdf,0x15,0x64,0x68,0x37,0x00,0xda,0x80,
        0xd1,0x44,0xf4,0x8b,0x6a,0x60,0x6d,0x3f,0xd3,0x92,0x4f,0x15,0xd5,0xef,0xdb,0x2d,
        0xf0,0x95,0xe4,0x2d,0xcb,0xd2,0x35,0xb4,0x6a,0x2c,0xe2,0x07,0xbc,0xe6,0xb2,0x78,
        0x62,0x57,0xf2,0x09,0x2f,0xb7,0x98,0x68,0x9b,0xa0,0x44,0x1e,0xf6,0xe5,0xde,0x1e,
        0xc6,0x84,0xa8,0xa4,0xb6,0xc3,0xb9,0x5e,0xad,0xe2,0xc1,0x87,0x87,0xcf,0x18,0xb5,
        0x68,0x5f,0x85,0xaa,0xc1,0x41,0xd6,0xb0,0x18,0xca,0x22,0x91,0x2b,0x6e,0x0a,0xc9,
        0xa4,0x7f,0x91,0xfc,0x56,0x15,0xa8,0x6c,0x8c,0xc7,0x01,0x1d,0x45,0x9a,0x9c,0x01,
        0xd1,0x1f,0xc7,0x99,0xdb,0x74,0x45,0xa0,0x4c,0x43,0x7f,0x68,0x8a,0x6d,0xa9,0xf3,
        0x44,0xe4,0x9c,0x78,0x66,0xe8,0x2f,0x54,0xbe,0x19,0xb3,0x56,0xdd,0x65,0x2b,0xe6,
        0x79,0xe1,0xb4,0xc9,0xb6,0x29,0xdd,0x52,0x70,0x96,0x42,0xf3,0x55,0x94,0x6e,0x31,
        0x13,0xb4,0x4a,0xf4,0x29,0x37,0x89,0xe7,0xdd,0xf4,0xdf,0x79,0xc2,0xf5,0xcf,0x69,
        0x71,0x16,0xe0,0x43,0x59,0x87,0xda,0x51,0xcc,0xee,0x8f,0xbc,0x1e,0xa8,0xd7,0xc9,
        0x6b,0xb3,0x92,0x12,0xec,0x98,0x4c,0xd3,0xe5,0x7e,0x90,0x53,0xaa,0x08,0x44,0x17},
        /*TST_D*/
        {0x6f,0x68,0x07,0x7f,0x44,0xff,0x4f,0x24,0x9c,0xd2,0x2b,0xc9,0x06,0x95,0x3b,0x92,
        0x08,0xf4,0x0b,0xdf,0x8d,0x3f,0xfd,0x03,0x2c,0x72,0xab,0x96,0xb6,0x9a,0x39,0x37,
        0x99,0x34,0xab,0x3d,0x51,0xa5,0xa9,0x00,0xa9,0xd0,0xc4,0x47,0x34,0x52,0x1a,0x8e,
        0x09,0x2b,0xb5,0x98,0x98,0x1b,0x0d,0x84,0xaf,0xf7,0x6e,0x55,0x4f,0xdc,0xab,0xe7,
        0x6f,0xeb,0x9f,0xe5,0x2c,0xca,0x28,0x77,0x8d,0x99,0xd2,0x0b,0x3f,0x28,0xfb,0x54,
        0x26,0x4c,0x5e,0xcc,0x72,0x29,0xad,0xc6,0x65,0x2f,0x90,0x00,0x19,0x5d,0x26,0x5d,
        0x75,0x2e,0xf8,0x8e,0x5b,0x55,0x69,0x76,0x74,0x07,0xcd,0x3d,0x26,0x28,0xae,0x6e,
        0x1a,0x75,0x00,0xe1,0x18,0x67,0x5d,0x2d,0x23,0x71,0xd6,0xb4,0xa4,0xde,0xf1,0x62,
        0xaa,0x6f,0x11,0x32,0xc4,0x26,0xbd,0xa9,0x9d,0x55,0x8e,0x17,0xe5,0x11,0xee,0xf7,
        0xc4,0x3c,0x93,0x3b,0x41,0xae,0x32,0x0b,0x4c,0x0c,0x21,0x95,0x31,0x58,0xc9,0x99,
        0x24,0x93,0x50,0x36,0x5a,0xbc,0xad,0xcf,0xe4,0x48,0xc8,0x64,0x5c,0x53,0xff,0xc8,
        0xfd,0x74,0xf7,0x6e,0xa1,0xda,0xaf,0xc8,0x47,0xa9,0x20,0x69,0xe5,0x08,0x00,0x21,
        0x1a,0xef,0xf0,0x94,0x09,0xde,0xb0,0x54,0xee,0x07,0xe9,0x2f,0x56,0x7a,0x68,0xe7,
        0x29,0xa6,0x0e,0x49,0xb3,0x89,0xdd,0x9b,0x57,0x93,0xc7,0xad,0xf4,0x77,0xb9,0x52,
        0xd3,0x38,0x2d,0x7c,0x94,0xd9,0x15,0x12,0xb9,0x55,0xba,0x92,0x39,0x92,0x0d,0x89,
        0xb2,0x40,0xdc,0x6e,0x82,0x69,0x24,0x67,0xd8,0x59,0x53,0x5a,0xc5,0x55,0x73,0xe1},
        /*TST_E*/
        {0x01,0x00,0x01},
        /*TST_ChalengeKeyESizeInBytes*/
        3,
        /*TST_ChallengeBuff*/
        {0xb1,0xbb,0x4c,0x39,0x83,0xa6,0xa8,0x15,0x64,0xe1,0x9a,0x92,0x33,0xe2,0x95,0xe9,
        0x96,0xc1,0x1f,0x18,0xe3,0x8e,0xd5,0xd7,0x41,0xe8,0xb0,0xcc,0x0a,0xcb,0x88,0x0e},
        /*TST_ChallengeBuffSize*/
        32,
        /*TST_SignedChallengeBuff*/
        {0x00},
        /*TST_SignedChallengeBuffSize*/
        256,
        /*TST_Key1SizeInBytes*/
        128,
        /*TST_E1*/
        {0x01,0x00,0x01},
        /*TST_E1SizeInBytes*/
        3,
        /*TST_N3*/
        {0x00},
        /*TST_N3SizeInBytes*/
        256,
        /*TST_D3*/
        {0x00},
        /*TST_D1SizeInBytes*/
        256,
        /*TST_E3*/
        {0x01,0x00,0x01},
        /*TST_E3SizeInBytes*/
        3,
        /*TST_N4*/
        {0x00},
        /*TST_N1SizeInBytes*/
        333,
        /*TST_D4*/
        {0x00},
        /*TST_D1SizeInBytes*/
        333,
        /*TST_E4*/
        {0x00},
        /*TST_E4SizeInBytes*/
        333,
        /*TST_P4*/
        {0x00},
        /*TST_P4SizeInBytes*/
        333,
        /*TST_Q4*/
        {0x00},
        /*TST_Q4SizeInBytes*/
        333,
        /*TST_DP4*/
        {0x00},
        /*TST_DP4SizeInBytes*/
        333,
        /*TST_DQ4*/
        {0x00},
        /*TST_DQ4SizeInBytes*/
        333,
        /*TST_Qinv4*/
        {0x00},
        /*TST_Qinv4SizeInBytes*/
        333,
        /*TST_N5*/
        {0xbe,0xf2,0xca,0x31,0x6e,0xd8,0x4a,0xc0,0x49,0xed,0xa5,0x0a,0x43,0x06,0x64,0x8c,
        0x26,0x7f,0x49,0xf3,0xc5,0x6b,0x7e,0x87,0x20,0x5f,0x26,0x96,0xe6,0xfc,0x85,0x99,
        0xf9,0xc2,0x62,0x88,0x89,0x70,0x20,0xa4,0x80,0x72,0xcd,0xbe,0x50,0x85,0xba,0x41,
        0xd5,0xc9,0xb6,0xb9,0xd6,0x87,0x76,0x6e,0x33,0x6c,0x8e,0x54,0x1c,0x0f,0xd7,0x1b,
        0x43,0xff,0x86,0xbd,0xa9,0x34,0x20,0xd9,0x6e,0xcb,0x7c,0x38,0xf9,0x0c,0x18,0x0a,
        0xd2,0xea,0x56,0xbe,0x0a,0x0b,0x83,0x6f,0xef,0x9a,0x48,0x08,0xf3,0xbe,0x19,0xa4,
        0x05,0x59,0x89,0x92,0x8e,0x97,0x5f,0xac,0x0d,0x86,0x98,0xe0,0x4e,0x7d,0xe8,0xba,
        0x21,0xe8,0x6c,0x04,0xe2,0x82,0x80,0xa1,0x37,0xc8,0x18,0x91,0x34,0x5b,0x8e,0xe7},
        /*TST_D5*/
        {0x99,0x8f,0xa5,0xbd,0xa5,0x77,0xfa,0x7d,0xb3,0xb6,0x93,0x50,0xb2,0x60,0x54,0xc2,
        0x45,0x3f,0x7e,0xd8,0xb5,0x7e,0xe2,0x4d,0x87,0x62,0x1e,0x25,0xa3,0x73,0x97,0x7a,
        0x21,0xdb,0x0a,0xe4,0xe5,0x2a,0xb0,0x85,0xba,0xeb,0x18,0xbd,0x22,0x02,0xb9,0xac,
        0xb2,0x62,0xbb,0x39,0xae,0xe6,0x57,0xfe,0xfe,0x0a,0x22,0x58,0x50,0x0d,0x09,0x1e,
        0x74,0x39,0xe8,0x4e,0x24,0x98,0xf7,0x75,0x0d,0x0f,0xa0,0x2e,0xb1,0x5a,0xb4,0xc5,
        0xf1,0xbe,0xf5,0x14,0x08,0x6a,0x0d,0x35,0x35,0xac,0xbf,0x05,0x1d,0xb5,0xfa,0x8a,
        0x89,0xd3,0x55,0x7b,0x54,0xdc,0x01,0xec,0xa5,0xe3,0x72,0x7b,0xaa,0x4c,0x24,0x30,
        0x05,0x67,0xad,0xe3,0xe5,0xd2,0x2e,0x9c,0x9c,0xf1,0x42,0x64,0x58,0x95,0x13,0xb1},
        /*TST_E5*/
        {0x01,0x00,0x01},
        /*TST_E5SizeInBytes*/
        3,
        /*TST_Key5SizeInBytes*/
        128,
        /*TST_P5*/
        {0xfe,0x23,0xcc,0xdf,0x86,0x69,0xea,0xbc,0x0e,0x16,0x13,0xa3,0x59,0x7f,0x75,0x7e,
        0xb6,0x00,0xed,0xdd,0xbb,0x11,0xca,0xb2,0x2c,0x88,0xc3,0xc8,0xdf,0xd9,0xe7,0x0c,
        0xf8,0x29,0xf3,0xb6,0xf9,0x24,0xfd,0xa1,0xc5,0x21,0x3c,0xaa,0xdc,0xb7,0xac,0xc7,
        0xc1,0x3c,0x10,0xb5,0x8a,0x9a,0x23,0xcb,0xd1,0xcb,0x41,0x5b,0x8d,0x66,0x2b,0xcf},
        /*TST_Q5*/
        {0xc0,0x58,0x95,0x51,0x1d,0xd8,0x3e,0x5f,0x38,0x43,0x9b,0x81,0x8c,0xf2,0xf8,0x9f,
        0xb6,0xd3,0xf4,0xc7,0x64,0xb6,0x0d,0x79,0x69,0x65,0x02,0x48,0x07,0xc0,0xb3,0x26,
        0x06,0xe7,0xf6,0xd0,0x7e,0x3a,0x45,0xfb,0x4d,0xd4,0xa9,0x63,0xb7,0x25,0x6b,0x38,
        0xab,0x22,0xce,0xf1,0x6c,0xed,0xe9,0x8e,0xde,0x69,0xd7,0x0a,0x9f,0x45,0xb9,0x69},
        /*TST_DP5*/
        {0x54,0xfd,0x69,0xfd,0x72,0xb9,0x27,0x2c,0x3e,0xd5,0xb9,0x39,0x8e,0xab,0xa6,0x82,
        0x7a,0xa1,0x72,0xeb,0x0d,0x2d,0x95,0x08,0xe3,0x05,0xd5,0xdb,0xee,0xa8,0xb3,0xb1,
        0x4d,0xa8,0xd1,0xfd,0x65,0xf2,0xad,0xf3,0x94,0xb6,0x59,0xd0,0x96,0x41,0xc2,0xc1,
        0x86,0xe8,0xec,0x79,0x99,0xe1,0x94,0x89,0x0c,0x1f,0x1a,0x3b,0x60,0xdd,0x43,0x57},
        /*TST_DQ5*/
        {0x95,0xbb,0x1f,0x99,0x82,0xbb,0x18,0x6a,0xb5,0x78,0xe3,0xb0,0x28,0xd1,0xe7,0xbb,
        0x24,0xee,0xc0,0xc9,0x0b,0x5c,0x31,0x07,0x07,0x85,0x8b,0x0e,0x19,0x82,0xe7,0xb2,
        0xbd,0x83,0x8b,0x7d,0xe8,0x15,0x62,0xee,0xeb,0x3a,0x96,0x16,0x3a,0xb7,0x15,0x4d,
        0x8a,0xe3,0x50,0xe7,0x5d,0x9d,0xa2,0xc8,0x05,0xd9,0xac,0x7d,0xe7,0x58,0xb6,0xa9},
        /*TST_Qinv5*/
        {0x59,0x90,0x77,0xd8,0x81,0x56,0xe0,0x36,0x71,0x11,0x1d,0x7e,0x70,0xf8,0xb8,0x8f,
        0x4a,0x98,0xbe,0xe0,0x2a,0x90,0x69,0x05,0xae,0xe4,0xe0,0xbd,0xe9,0xb2,0x61,0xb6,
        0xa6,0x0b,0x12,0x8b,0x3c,0x0e,0xdf,0xdd,0xa7,0x4d,0x05,0x5f,0x07,0x6f,0x65,0x76,
        0x1e,0x8b,0x3f,0x65,0x62,0xbd,0xe8,0xe1,0xc4,0x36,0x7f,0x4c,0xf5,0x60,0xc7,0x27},
        /*TST_DataIn*/   
        {0x2e,0xf5,0x7a,0x48,0xfc,0xfc,0x57,0x26,0x48,0xa1,0x0c,0x58,0xf6,0x09,0xbd,0xca,
        0x52,0x20,0x35,0x69,0xa4,0xde,0x1d,0x87,0x05,0xca,0x72,0x81,0x70,0xbd,0x36,0x9f,
        0x1c,0xe9,0x65,0x3b,0x09,0x19,0x2a,0x26,0xd9,0x3a,0x53,0x47,0xe2,0x1b,0x03,0x85,
        0x81,0x71,0xa6,0xe8,0xb1,0x1e,0x2a,0xfa,0xdc,0xb3,0x6d,0x74,0xf1,0x33,0xf1,0x16,
        0xb6,0x1a,0xd7,0xd7,0x60,0x9d,0x0b,0x3e,0x61,0x34,0xbc,0x10,0x81,0x56,0x0f,0x2b,
        0x30,0x83,0x14,0xb2,0x1a,0x88,0xf9,0x6a,0xfd,0xff,0x7d,0x64,0xb7,0x15,0xa8,0xdd,
        0xa4,0x90,0xb9,0x62,0x26,0x10,0x61,0x38,0x85,0x94,0x2e,0xfa,0xfa,0x41,0x4a,0x84,
        0x06,0x5f,0x65,0x10,0x08,0xa5,0xf0,0x9f,0x0f,0xb6,0x8c,0x9b,0xed,0xeb,0xc2,0xba},
        /*TST_DataInSize*/ 
        128,
        /*TST_DataOut*/  
        {0x00},
        /*TST_DataOutSize*/
        256,
        /*TST_OperationMode*/
        CRYS_RSA_HASH_SHA1_mode,
        /*TST_SaltLengthSign*/
        23,
        /*TST_SaltLengthVerify*/
        23,
    },
    #if !TST_LIMITED_MEMORY_PLATFROM
    {
        /*TST_Name*/
        {"ATP test AuthObject-SpecialDataOpRSA - 2048 key"},
        /*TST_ChalengeKeySizeInBytes*/
        256,
        /*TST_N*/
        {0xbd,0x0c,0x65,0x0a,0x5d,0x18,0x41,0x32,0x94,0xfc,0xde,0x65,0x0c,0x2d,0xa5,0x1e,
        0x3f,0xd8,0xaf,0x63,0x4f,0x2c,0xb2,0xa5,0x71,0xb9,0x75,0xa5,0x3e,0x5c,0x55,0x85,
        0x1c,0x2d,0xfa,0x75,0x5e,0xd3,0xd3,0x42,0x78,0x36,0x05,0xe6,0x31,0x48,0xfa,0xaa,
        0x3b,0x56,0x38,0xe3,0x51,0x01,0x39,0x49,0xdf,0x15,0x64,0x68,0x37,0x00,0xda,0x80,
        0xd1,0x44,0xf4,0x8b,0x6a,0x60,0x6d,0x3f,0xd3,0x92,0x4f,0x15,0xd5,0xef,0xdb,0x2d,
        0xf0,0x95,0xe4,0x2d,0xcb,0xd2,0x35,0xb4,0x6a,0x2c,0xe2,0x07,0xbc,0xe6,0xb2,0x78,
        0x62,0x57,0xf2,0x09,0x2f,0xb7,0x98,0x68,0x9b,0xa0,0x44,0x1e,0xf6,0xe5,0xde,0x1e,
        0xc6,0x84,0xa8,0xa4,0xb6,0xc3,0xb9,0x5e,0xad,0xe2,0xc1,0x87,0x87,0xcf,0x18,0xb5,
        0x68,0x5f,0x85,0xaa,0xc1,0x41,0xd6,0xb0,0x18,0xca,0x22,0x91,0x2b,0x6e,0x0a,0xc9,
        0xa4,0x7f,0x91,0xfc,0x56,0x15,0xa8,0x6c,0x8c,0xc7,0x01,0x1d,0x45,0x9a,0x9c,0x01,
        0xd1,0x1f,0xc7,0x99,0xdb,0x74,0x45,0xa0,0x4c,0x43,0x7f,0x68,0x8a,0x6d,0xa9,0xf3,
        0x44,0xe4,0x9c,0x78,0x66,0xe8,0x2f,0x54,0xbe,0x19,0xb3,0x56,0xdd,0x65,0x2b,0xe6,
        0x79,0xe1,0xb4,0xc9,0xb6,0x29,0xdd,0x52,0x70,0x96,0x42,0xf3,0x55,0x94,0x6e,0x31,
        0x13,0xb4,0x4a,0xf4,0x29,0x37,0x89,0xe7,0xdd,0xf4,0xdf,0x79,0xc2,0xf5,0xcf,0x69,
        0x71,0x16,0xe0,0x43,0x59,0x87,0xda,0x51,0xcc,0xee,0x8f,0xbc,0x1e,0xa8,0xd7,0xc9,
        0x6b,0xb3,0x92,0x12,0xec,0x98,0x4c,0xd3,0xe5,0x7e,0x90,0x53,0xaa,0x08,0x44,0x17},
        /*TST_D*/
        {0x6f,0x68,0x07,0x7f,0x44,0xff,0x4f,0x24,0x9c,0xd2,0x2b,0xc9,0x06,0x95,0x3b,0x92,
        0x08,0xf4,0x0b,0xdf,0x8d,0x3f,0xfd,0x03,0x2c,0x72,0xab,0x96,0xb6,0x9a,0x39,0x37,
        0x99,0x34,0xab,0x3d,0x51,0xa5,0xa9,0x00,0xa9,0xd0,0xc4,0x47,0x34,0x52,0x1a,0x8e,
        0x09,0x2b,0xb5,0x98,0x98,0x1b,0x0d,0x84,0xaf,0xf7,0x6e,0x55,0x4f,0xdc,0xab,0xe7,
        0x6f,0xeb,0x9f,0xe5,0x2c,0xca,0x28,0x77,0x8d,0x99,0xd2,0x0b,0x3f,0x28,0xfb,0x54,
        0x26,0x4c,0x5e,0xcc,0x72,0x29,0xad,0xc6,0x65,0x2f,0x90,0x00,0x19,0x5d,0x26,0x5d,
        0x75,0x2e,0xf8,0x8e,0x5b,0x55,0x69,0x76,0x74,0x07,0xcd,0x3d,0x26,0x28,0xae,0x6e,
        0x1a,0x75,0x00,0xe1,0x18,0x67,0x5d,0x2d,0x23,0x71,0xd6,0xb4,0xa4,0xde,0xf1,0x62,
        0xaa,0x6f,0x11,0x32,0xc4,0x26,0xbd,0xa9,0x9d,0x55,0x8e,0x17,0xe5,0x11,0xee,0xf7,
        0xc4,0x3c,0x93,0x3b,0x41,0xae,0x32,0x0b,0x4c,0x0c,0x21,0x95,0x31,0x58,0xc9,0x99,
        0x24,0x93,0x50,0x36,0x5a,0xbc,0xad,0xcf,0xe4,0x48,0xc8,0x64,0x5c,0x53,0xff,0xc8,
        0xfd,0x74,0xf7,0x6e,0xa1,0xda,0xaf,0xc8,0x47,0xa9,0x20,0x69,0xe5,0x08,0x00,0x21,
        0x1a,0xef,0xf0,0x94,0x09,0xde,0xb0,0x54,0xee,0x07,0xe9,0x2f,0x56,0x7a,0x68,0xe7,
        0x29,0xa6,0x0e,0x49,0xb3,0x89,0xdd,0x9b,0x57,0x93,0xc7,0xad,0xf4,0x77,0xb9,0x52,
        0xd3,0x38,0x2d,0x7c,0x94,0xd9,0x15,0x12,0xb9,0x55,0xba,0x92,0x39,0x92,0x0d,0x89,
        0xb2,0x40,0xdc,0x6e,0x82,0x69,0x24,0x67,0xd8,0x59,0x53,0x5a,0xc5,0x55,0x73,0xe1},
        /*TST_E*/
        {0x01,0x00,0x01},
        /*TST_ChalengeKeyESizeInBytes*/
        3,
        /*TST_ChallengeBuff*/
        {0xb1,0xbb,0x4c,0x39,0x83,0xa6,0xa8,0x15,0x64,0xe1,0x9a,0x92,0x33,0xe2,0x95,0xe9,
        0x96,0xc1,0x1f,0x18,0xe3,0x8e,0xd5,0xd7,0x41,0xe8,0xb0,0xcc,0x0a,0xcb,0x88,0x0e},
        /*TST_ChallengeBuffSize*/
        32,
        /*TST_SignedChallengeBuff*/
        {0x00},
        /*TST_SignedChallengeBuffSize*/
        256,
        /*TST_Key1SizeInBytes*/
        256,
        /*TST_E1*/
        {0x01,0x00,0x01},
        /*TST_E1SizeInBytes*/
        3,
        /*TST_N3*/
        {0x00},
        /*TST_N32SizeInBytes*/
        256,
        /*TST_D3*/
        {0x00},
        /*TST_D3SizeInBytes*/
        256,
        /*TST_E3*/
        {0x01,0x00,0x01},
        /*TST_E3SizeInBytes*/
        3,
        /*TST_N4*/
        {0x00},
        /*TST_N4SizeInBytes*/
        333,
        /*TST_D4*/
        {0x00},
        /*TST_D4SizeInBytes*/
        333,
        /*TST_E4*/
        {0x00},
        /*TST_E4SizeInBytes*/
        333,
        /*TST_P4*/
        {0x00},
        /*TST_P4SizeInBytes*/
        333,
        /*TST_Q4*/
        {0x00},
        /*TST_Q4SizeInBytes*/
        333,
        /*TST_DP4*/
        {0x00},
        /*TST_DP4SizeInBytes*/
        333,
        /*TST_DQ4*/
        {0x00},
        /*TST_DQ4SizeInBytes*/
        333,
        /*TST_Qinv4*/
        {0x00},
        /*TST_Qinv4SizeInBytes*/
        333,
        /*TST_N5*/
        {0xcd,0x7d,0x16,0xc4,0xe6,0x0b,0xd8,0xfa,0x63,0x70,0x1d,0xe3,0x4d,0xf2,0xc2,0x30,
        0xe2,0xb2,0x6f,0x39,0xe7,0x2e,0x87,0x6c,0xd1,0xb1,0x6d,0xdd,0x08,0xc4,0x19,0xef,
        0x20,0x65,0xd2,0xed,0xc2,0x55,0x1f,0x56,0xca,0x5d,0x0e,0x90,0xec,0x54,0x67,0xb6,
        0x2f,0x02,0x82,0xf9,0x7b,0x38,0x22,0xe8,0x4c,0x6f,0x9d,0x19,0xb1,0x0f,0x9b,0xb2,
        0x4b,0x97,0x9e,0x5f,0x29,0x29,0xfb,0x4d,0x82,0xec,0xcd,0xd7,0x08,0xa5,0x56,0xfe,
        0x96,0x2a,0x3c,0xd2,0xe4,0x3e,0xbf,0x89,0xee,0xae,0x6c,0x1b,0xbe,0x54,0x5e,0xa1,
        0xea,0x0c,0x94,0x7b,0x62,0x88,0x36,0xe0,0x5f,0x74,0x59,0x4c,0x13,0x75,0xb0,0x0f,
        0xaa,0x5d,0x5f,0xc9,0x24,0x04,0xdc,0x18,0xb0,0x45,0x1e,0xa2,0xca,0x1d,0x2f,0xbd,
        0x96,0xfb,0xb3,0x10,0x7c,0x61,0x00,0x7e,0xcf,0x85,0x93,0x42,0xd9,0xc7,0xb6,0x2d,
        0x65,0x95,0xfa,0x15,0x38,0xba,0x38,0xc2,0x5d,0xdd,0x37,0xbe,0x32,0xcd,0x4f,0x08,
        0xb3,0xe5,0xfe,0xce,0x91,0x23,0xf9,0xd2,0x6d,0x64,0x24,0x3c,0xb4,0x31,0xe9,0x1f,
        0x0a,0xbb,0x24,0xc6,0x25,0x49,0x5a,0x9f,0xd6,0x68,0x30,0x3e,0xd6,0xb8,0xc9,0x65,
        0x96,0x8d,0x27,0x0c,0xd9,0x51,0x95,0x94,0x1d,0x8c,0x3d,0xd6,0x93,0x6a,0x22,0x4b,
        0x50,0x62,0xc6,0xed,0x13,0x90,0x9d,0xc2,0x1e,0x74,0xd0,0x20,0x55,0x90,0x34,0xcf,
        0xf5,0x32,0x2a,0xf5,0x69,0xe2,0x49,0x7b,0xa3,0x93,0xb6,0x3f,0x64,0x73,0x1a,0xeb,
        0x19,0x9c,0x52,0xd3,0xfc,0xbc,0xfb,0x35,0xfe,0x99,0x7b,0xd2,0x70,0xb6,0xf5,0xb3},
        /*TST_D5*/
        {0x1d,0x59,0xdd,0xb3,0xb8,0x2c,0x3f,0x0c,0xdc,0xc1,0x39,0xf3,0xaa,0xc1,0x9f,0x0d,
        0x3e,0x84,0x40,0x30,0xe4,0x1d,0x98,0x48,0x69,0xd7,0x4f,0x1b,0x00,0x52,0x8a,0x65,
        0xc6,0x99,0xe4,0xbc,0x03,0x43,0x07,0x5b,0xed,0x41,0xc7,0x7f,0xd9,0xd1,0xe0,0x92,
        0x7c,0x3a,0x7e,0x9c,0xc6,0x05,0xe9,0xae,0x86,0xa4,0x76,0xab,0x21,0xc8,0x59,0xf3,
        0xe8,0xaa,0x3a,0x7b,0xdb,0x34,0x5c,0xe9,0xe0,0x66,0x94,0xac,0x3f,0x56,0xe6,0x8b,
        0x2c,0xc5,0xd1,0xb4,0x49,0xd7,0xd0,0xa2,0x12,0x0e,0xa5,0xf0,0x7c,0x8a,0x2e,0x8e,
        0x30,0x11,0x25,0xf0,0x4d,0xcd,0xa9,0x10,0xf9,0x71,0x74,0x03,0xd2,0xcf,0xbf,0x9b,
        0x2d,0x39,0x73,0x22,0x16,0xdb,0xfe,0xd8,0x23,0xed,0x6b,0x87,0xd3,0x18,0xc2,0x25,
        0xaf,0xbe,0xf0,0xb7,0xb0,0xe5,0x98,0x86,0x18,0x36,0x8c,0xe7,0xa1,0x43,0x50,0x54,
        0xd9,0xdb,0xd8,0xde,0xe1,0xa9,0x1a,0x65,0xb1,0xd5,0xec,0xa7,0xa0,0x11,0x1a,0xee,
        0xe6,0xf6,0xc1,0xa5,0x9b,0x9b,0x29,0x5e,0x77,0x22,0x90,0xd7,0x4e,0x70,0xa2,0x49,
        0x81,0x12,0xd1,0xba,0xfb,0x4a,0xa7,0x9d,0xc7,0x0e,0xa2,0xc8,0xf3,0xbb,0x78,0xb3,
        0x90,0x63,0x8a,0xc0,0xca,0x45,0xbe,0xfb,0xc6,0x32,0x23,0xa5,0x1a,0x0c,0x9e,0x7e,
        0x0b,0xc1,0x87,0xe4,0xf1,0x34,0x16,0x31,0xaa,0xd6,0x83,0x78,0xd9,0x7b,0xef,0x87,
        0xe8,0x42,0xde,0xee,0x2d,0x5e,0xa5,0x49,0xba,0x07,0xf0,0xd1,0xde,0x54,0xb4,0xfa,
        0x22,0xe2,0x45,0xf4,0xa7,0xa4,0x63,0x2c,0x0a,0xa0,0x0c,0x71,0x9a,0xd5,0x96,0x21},
        /*TST_E5*/
        {0x01,0x00,0x01},
        /*TST_E5SizeInBytes*/
        3,
        /*TST_Key5SizeInBytes*/
        256,
        /*TST_P5*/
        {0xf8,0x15,0xbf,0x47,0x4a,0xa9,0x50,0xca,0x43,0x14,0x9e,0x29,0x01,0xc2,0x68,0xc4,
        0x64,0xa5,0xa4,0xde,0x12,0x7d,0xca,0x0c,0x84,0x18,0x49,0x2d,0xfc,0x79,0xea,0xb9,
        0x3b,0xc2,0x5f,0x80,0x51,0x78,0x73,0x14,0x1f,0xd3,0xed,0x19,0x5d,0x26,0x2f,0xc0,
        0xaf,0x52,0xd8,0xa6,0xee,0x51,0x94,0x07,0x65,0x4d,0xbf,0x53,0xd6,0xb9,0x42,0xf9,
        0x67,0x3e,0xe1,0xf8,0x2e,0xd4,0x6f,0x77,0xd8,0x4c,0x3c,0x35,0x31,0x06,0x7a,0x90,
        0x15,0xa7,0xb1,0x80,0x71,0x43,0x49,0xcf,0x02,0x12,0xbe,0x69,0x45,0x68,0xe1,0xb5,
        0x28,0x1d,0xb5,0xf1,0x49,0x1e,0x45,0xea,0xf7,0x59,0x41,0x59,0xd2,0x68,0x9e,0xc1,
        0x5d,0x82,0x00,0xdb,0x21,0x6c,0x50,0x96,0xbb,0xd6,0xbf,0x43,0xfd,0xb6,0x06,0x11},
        /*TST_Q5*/
        {0xd4,0x0b,0x6e,0xdc,0x1a,0x14,0xd9,0x09,0x2b,0x42,0x06,0xa0,0x32,0x91,0xe1,0x31,
        0x0b,0xa3,0xd2,0x6b,0x73,0x5b,0x40,0x63,0xa3,0x3f,0xae,0x72,0x1c,0x37,0x5c,0x53,
        0x22,0xfd,0x04,0xac,0x43,0x34,0x43,0xb9,0x8e,0xde,0x4b,0x0c,0xef,0x4a,0x7e,0x7c,
        0x51,0xef,0xb3,0x41,0x3c,0x02,0x7f,0x9d,0xeb,0x94,0xda,0x53,0x97,0x0d,0xde,0xe4,
        0x0b,0xe3,0x48,0x53,0x74,0x84,0x7f,0x93,0xc6,0x32,0x25,0x41,0xf3,0x2c,0xb3,0x01,
        0xf8,0x7a,0xb7,0x9c,0x06,0x48,0xa4,0x00,0xa5,0xa2,0xa0,0xd0,0x8d,0x5b,0x3a,0xd3,
        0x0c,0x03,0x39,0x11,0xaf,0x24,0x42,0x58,0x46,0x03,0x30,0xff,0x84,0xe5,0xfe,0xb9,
        0x6c,0x20,0xa4,0x51,0x41,0x3c,0xf4,0x3a,0xd8,0xa6,0x60,0x13,0x9f,0xbd,0x2b,0x83},
        /*TST_DP5*/
        {0xc0,0x8f,0x78,0xc1,0xe8,0x64,0xd5,0xcd,0xb9,0x15,0xa6,0xd1,0xe3,0x88,0xb7,0xf3,
        0x40,0xc0,0x05,0xe1,0x4d,0x6f,0x0f,0xc6,0x79,0x3d,0xb4,0x87,0x9a,0x42,0x33,0x7c,
        0x05,0xb3,0x90,0x97,0x34,0x25,0x8f,0x05,0x5e,0xd3,0x0b,0x65,0x35,0x95,0x2f,0x59,
        0x9b,0x7c,0x6d,0xa7,0xdc,0xb1,0xbb,0x79,0xa6,0x1b,0x1b,0xd8,0x02,0x82,0x18,0x47,
        0x27,0xe9,0x7a,0x52,0x3e,0x5f,0x2c,0x0a,0x54,0xfc,0x8f,0x7b,0x26,0x0b,0x86,0x54,
        0x92,0x4a,0x70,0x8f,0x66,0xda,0xb8,0xce,0x92,0x28,0x64,0x5d,0xa7,0xbf,0x89,0xfa,
        0x28,0x22,0x2f,0x98,0x12,0x8e,0x09,0xed,0x20,0x82,0xca,0x23,0xe3,0x1a,0xcb,0xa7,
        0x01,0x62,0xa8,0x31,0x6e,0x96,0xf9,0x52,0x96,0x88,0x50,0x3b,0x81,0x11,0xa9,0x51},
        /*TST_DQ5*/
        {0x19,0xd5,0xde,0xc7,0x00,0x82,0x83,0xc3,0x23,0x3b,0x23,0x35,0x87,0x93,0xd0,0x9d,
        0x3a,0x2e,0xd6,0xa7,0x72,0xe1,0xae,0x61,0xb5,0x75,0x3f,0xda,0xf5,0x67,0x25,0x5f,
        0x97,0xc6,0xbe,0x38,0x02,0xe4,0x2e,0x50,0x40,0x81,0x03,0x21,0xeb,0x51,0xe7,0x41,
        0x5c,0x76,0x59,0x1f,0xdc,0xa0,0xed,0x4d,0x9f,0x73,0x7e,0x7a,0x6a,0xd0,0x2c,0xd5,
        0x1a,0x41,0xb2,0x01,0x41,0x14,0x17,0xbb,0x38,0x8d,0xc9,0x8e,0x54,0x83,0xa0,0xb7,
        0xdf,0xbf,0x8b,0xf9,0x7d,0xa6,0x82,0x1c,0xf6,0x11,0x6f,0x88,0x99,0x80,0x81,0x15,
        0x4f,0xc4,0x60,0xc2,0xaf,0xd5,0x3a,0x24,0x29,0x3b,0xa0,0x4f,0xb1,0xb0,0x98,0x2d,
        0x9d,0x68,0x08,0xbd,0x41,0xb6,0x9c,0x87,0x42,0xf8,0x5a,0x82,0x69,0x97,0x11,0xe3},
        /*TST_Qinv5*/
        {0x7a,0xcf,0x24,0x32,0xae,0x72,0x25,0xc2,0x6d,0xbd,0x2b,0xec,0x35,0xba,0xca,0x34,
        0xff,0x09,0x9b,0x79,0x07,0xa6,0xb4,0x57,0x1a,0x7f,0xa9,0xb6,0xc1,0x7a,0x36,0x8e,
        0x1c,0xf9,0x28,0x97,0x03,0x1d,0xab,0x3f,0x1c,0xf5,0x93,0x34,0x9d,0xb7,0xd4,0x36,
        0x9c,0x71,0xdd,0xd1,0x2e,0xa1,0x13,0x6d,0xed,0xae,0x77,0xa2,0x73,0xb1,0x86,0xab,
        0x86,0x6a,0x60,0xf1,0x82,0x06,0x8e,0xb3,0x53,0x8d,0xcd,0xe1,0x32,0x07,0xba,0xc2,
        0xd6,0xe1,0x34,0x76,0x01,0x40,0xbf,0xdc,0x72,0x48,0x3b,0xec,0xab,0x7d,0x24,0xf1,
        0x21,0xb2,0x51,0x85,0xed,0x86,0x06,0x1e,0x84,0x07,0x51,0xe7,0xe4,0x89,0x22,0x79,
        0x2d,0x1b,0xd8,0x64,0x8f,0x62,0x81,0x04,0xa2,0xe0,0xc3,0x88,0x73,0x2a,0x54,0xa4},
        /*TST_DataIn*/   
        {0x45,0x75,0xd0,0x6c,0x41,0xb4,0xbb,0xf3,0x11,0x55,0xdc,0xc4,0x48,0xf5,0x6d,0xfb,
        0x21,0x31,0xa8,0xc0,0xb5,0x0c,0x94,0xc9,0x71,0x90,0x1e,0x21,0xc6,0xb9,0x6b,0x28,
        0x22,0x8e,0x6d,0xdc,0x20,0x91,0xb4,0x56,0xfc,0x59,0x87,0x97,0x49,0x7e,0x34,0x85,
        0xe6,0xb5,0xa4,0x31,0x2e,0x3c,0x32,0x5b,0x6f,0x79,0xbd,0x38,0x9d,0xde,0xfc,0x73,
        0x48,0x0f,0x12,0x71,0xcc,0x47,0x63,0xd9,0xc8,0xf8,0xa5,0x54,0xd1,0xb1,0x3a,0x91,
        0x67,0x45,0xbd,0x8d,0x27,0x2a,0xdb,0x11,0x43,0x1f,0x64,0x7c,0x30,0x11,0xa1,0xc2,
        0x9e,0x40,0xe9,0xb5,0xad,0x9e,0x6f,0x83,0x5e,0x77,0x5e,0x80,0x47,0x57,0x28,0x26,
        0x8c,0x29,0x1a,0x5a,0x0a,0x9c,0x35,0xf1,0xd5,0xcb,0x39,0x73,0xe5,0x1c,0x02,0x1f,
        0x0c,0x68,0x17,0x2f,0x2b,0x5d,0x81,0x5d,0xa6,0x21,0xd9,0xa5,0x15,0x38,0xa5,0x4d,
        0x3d,0xa8,0xe5,0x23,0x3e,0x5b,0xe8,0x06,0x0d,0xc4,0x64,0xa7,0x25,0xc6,0xc6,0x91,
        0x7a,0xd1,0xc7,0x67,0xaf,0x4e,0x40,0x6d,0x88,0x3d,0x3f,0x4a,0xa2,0x1c,0x5a,0x0d,
        0x62,0x0b,0x43,0x6d,0x2b,0x2f,0x9d,0x55,0xd4,0x54,0x0e,0xa0,0x59,0xd6,0x96,0x21,
        0xd0,0xc1,0x1f,0xe6,0x9f,0x37,0x55,0xbd,0xed,0x12,0xb7,0xf8,0x56,0xcb,0xee,0x6e,
        0xe3,0x9b,0x5e,0xc2,0x39,0xdf,0xfc,0xe8,0x10,0xc1,0x5f,0xe4,0xe7,0x15,0x19,0xd5,
        0xf6,0x81,0x47,0x33,0x65,0xe1,0x67,0x55,0xbb,0xe9,0x6a,0x36,0x99,0x0c,0x0a,0x78,
        0xa8,0x9d,0x5e,0xa9,0xd0,0x35,0xac,0xc6,0xab,0x54,0x7e,0xfd,0x39,0x4b,0xf8,0xb7},
        /*TST_DataInSize*/ 
        256,
        /*TST_DataOut*/  
        {0x00},
        /*TST_DataOutSize*/
        256,
        /*TST_OperationMode*/
        CRYS_RSA_HASH_SHA1_mode,
        /*TST_SaltLengthSign*/
        23,
        /*TST_SaltLengthVerify*/
        23,
    },
    #endif
};

const int TST_NumberOf_SST_TST_ATP_SpecialDataOpAESTests = sizeof(TST_ATP_SpecialDataOpAESTestData)/sizeof(TST_ATP_SpecialDataOpAESTestData[0]);
const int TST_NumberOf_SST_TST_ATP_SpecialDataOpDESTests = sizeof(TST_ATP_SpecialDataOpDESTestData)/sizeof(TST_ATP_SpecialDataOpDESTestData[0]);
const int TST_NumberOf_SST_TST_ATP_SpecialDataOpHMACTests = sizeof(TST_ATP_SpecialDataOpHMACTestData)/sizeof(TST_ATP_SpecialDataOpHMACTestData[0]);
const int TST_NumberOf_SST_TST_ATP_SpecialDataOpRSATests = sizeof(TST_ATP_SpecialDataOpRSATestData)/sizeof(TST_ATP_SpecialDataOpRSATestData[0]);

#endif

